/*
 * Decompiled with CFR 0.152.
 */
package datastructures;

import datastructures.IndividualInfo;
import java.util.BitSet;

public class Individual {
    public static int count = 0;
    private IndividualInfo info;
    private final BitSet genotypeVariables;

    public Individual(String FAM_ID, String IND_ID, String PAT_ID, String MAT_ID, String sex, String phenotype, int numberOfSNPs, BitSet genotypeBitSet) {
        this.info = new IndividualInfo(FAM_ID, IND_ID, PAT_ID, MAT_ID, sex, phenotype, numberOfSNPs);
        this.genotypeVariables = (BitSet)genotypeBitSet.clone();
    }

    public Individual(IndividualInfo indInfo, BitSet genotypeBitSet) {
        this.info = indInfo;
        this.genotypeVariables = genotypeBitSet;
    }

    public IndividualInfo getIndividualInfo() {
        return this.info;
    }

    public void setIndividualInfo(IndividualInfo indivInfo) {
        this.info = indivInfo;
    }

    public BitSet getGenotype() {
        return this.genotypeVariables;
    }

    public String toString() {
        StringBuffer indiv = new StringBuffer(String.valueOf(this.info.getFAM_ID()) + "\t" + this.info.getIND_ID() + "\t" + this.info.getMAT_ID() + "\t" + this.info.getPAT_ID() + "\t" + this.info.getSex() + "\t" + this.info.getPhenotype());
        int snp = 0;
        while (snp < this.info.getNumberOfSNPs()) {
            int minallelecount = 0;
            if (this.genotypeVariables.get(2 * snp + 1)) {
                minallelecount = 2;
            } else if (this.genotypeVariables.get(2 * snp)) {
                minallelecount = 1;
            }
            indiv.append("\t" + minallelecount);
            ++snp;
        }
        return indiv.toString();
    }
}

