/*
 * Decompiled with CFR 0.152.
 */
package datastructures;

import datastructures.UserParameters;
import java.util.BitSet;

public class CarrierIndex {
    private BitSet[] caseStatus;
    private BitSet[] controlStatus;

    public CarrierIndex(int numberOfVariables) {
        this.caseStatus = new BitSet[numberOfVariables];
        this.controlStatus = new BitSet[numberOfVariables];
    }

    public void setCaseCarrierIndex(BitSet caseCarriers, int variable) {
        this.caseStatus[variable] = caseCarriers;
    }

    public void setControlCarrierIndex(BitSet controlCarriers, int variable) {
        this.controlStatus[variable] = controlCarriers;
    }

    public BitSet getCaseCarrierIndex(int variable) {
        return (BitSet)this.caseStatus[variable].clone();
    }

    public BitSet getControlCarrierIndex(int variable) {
        return (BitSet)this.controlStatus[variable].clone();
    }

    public int[][] getObservedCaseCarriers(UserParameters userParams, int[] variableArray) {
        assert (variableArray.length == 2);
        int[][] noOfCaseCarriers = new int[2][2];
        BitSet var1 = this.getCaseCarrierIndex(variableArray[0]);
        BitSet var1not = (BitSet)var1.clone();
        var1not.flip(0, userParams.getNumber_of_cases());
        BitSet var2 = this.getCaseCarrierIndex(variableArray[1]);
        BitSet var2not = (BitSet)var2.clone();
        var2not.flip(0, userParams.getNumber_of_cases());
        BitSet temp111 = new BitSet(userParams.getNumber_of_cases());
        temp111.set(0, userParams.getNumber_of_cases());
        BitSet temp110 = (BitSet)temp111.clone();
        BitSet temp101 = (BitSet)temp111.clone();
        BitSet temp100 = (BitSet)temp111.clone();
        temp111.and(var1);
        temp111.and(var2);
        temp110.and(var1);
        temp110.and(var2not);
        temp101.and(var1not);
        temp101.and(var2);
        temp100.and(var1not);
        temp100.and(var2not);
        noOfCaseCarriers[1][1] = temp111.cardinality();
        noOfCaseCarriers[1][0] = temp110.cardinality();
        noOfCaseCarriers[0][1] = temp101.cardinality();
        noOfCaseCarriers[0][0] = temp100.cardinality();
        return noOfCaseCarriers;
    }

    public int[][] getObservedControlCarriers(UserParameters userParams, int[] variableArray) {
        assert (variableArray.length == 2);
        int[][] noOfControlCarriers = new int[2][2];
        BitSet var1 = this.getControlCarrierIndex(variableArray[0]);
        BitSet var1not = (BitSet)var1.clone();
        var1not.flip(0, userParams.getNumber_of_controls());
        BitSet var2 = this.getControlCarrierIndex(variableArray[1]);
        BitSet var2not = (BitSet)var2.clone();
        var2not.flip(0, userParams.getNumber_of_controls());
        BitSet temp111 = new BitSet(userParams.getNumber_of_controls());
        temp111.set(0, userParams.getNumber_of_controls());
        BitSet temp110 = (BitSet)temp111.clone();
        BitSet temp101 = (BitSet)temp111.clone();
        BitSet temp100 = (BitSet)temp111.clone();
        temp111.and(var1);
        temp111.and(var2);
        temp110.and(var1);
        temp110.and(var2not);
        temp101.and(var1not);
        temp101.and(var2);
        temp100.and(var1not);
        temp100.and(var2not);
        noOfControlCarriers[1][1] = temp111.cardinality();
        noOfControlCarriers[1][0] = temp110.cardinality();
        noOfControlCarriers[0][1] = temp101.cardinality();
        noOfControlCarriers[0][0] = temp100.cardinality();
        return noOfControlCarriers;
    }
}

