/*
 * Decompiled with CFR 0.152.
 */
package algorithm;

import datastructures.WorkUnit;
import gridmath.CaseMatrixBase;
import gridmath.MatrixOperations;
import gridmath.NumberOfCombinations;
import io.OutputWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import pac.SamplingThread;
import pac.SearchDatastructure;
import preprocessing.ParameterOptimizer;
import preprocessing.SimpleConstraintHandler;

public class ProbApproxCompleteSearch {
    private SearchDatastructure searcher;
    private OutputWriter outputter;
    private long totalProjectedTrials = 0L;
    private long totalProjectedCandidates = 0L;

    public ProbApproxCompleteSearch(SearchDatastructure I, OutputWriter O) throws IOException {
        this.searcher = I;
        this.outputter = O;
    }

    public void doPACSearch() throws Exception {
        SimpleConstraintHandler searchFilter = new SimpleConstraintHandler(this.searcher);
        CaseMatrixBase pSignificantMatrix = searchFilter.getPSignificantMatrix();
        CaseMatrixBase pLEMatrix = searchFilter.getPLEMatrix();
        NumberOfCombinations combinations = new NumberOfCombinations(this.searcher);
        combinations.compute(MatrixOperations.calculateCombinations, null, true);
        searchFilter = null;
        System.out.println("\nOptimally distributing search effort over filters (this may take a while) ... ");
        ParameterOptimizer optParams = new ParameterOptimizer(this.searcher);
        Vector<WorkUnit> distributedWorkSet = optParams.optimallyDistributeWork(pSignificantMatrix, pLEMatrix, combinations);
        ArrayList<SamplingThread> threadList = this.distributeThisWork(distributedWorkSet);
        this.searcher.stage1Time = 0L;
        this.searcher.stage2Time = 0L;
        Runtime.getRuntime().gc();
        System.out.println("CPU cores utilized = " + this.searcher.userParams.getMaxThreads());
        ExecutorService executor = Executors.newFixedThreadPool(this.searcher.userParams.getMaxThreads());
        boolean oddNumberOfThreads = false;
        if (threadList.size() % 2 == 1) {
            oddNumberOfThreads = true;
        }
        int threadNo = 0;
        while (threadNo < threadList.size() / 2) {
            executor.execute(threadList.get(threadList.size() - 1 - threadNo));
            executor.execute(threadList.get(threadNo));
            ++threadNo;
        }
        if (oddNumberOfThreads) {
            executor.execute(threadList.get(threadNo));
        }
        executor.shutdown();
        while (!executor.isTerminated()) {
            Thread.sleep(120000L);
            this.printProgressAndProjections();
        }
        this.outputter.Close();
    }

    public ArrayList<SamplingThread> distributeThisWork(Vector<WorkUnit> distributedWorkSet) {
        int numberOfWorkerThreads = 0;
        ArrayList<SamplingThread> threadList = new ArrayList<SamplingThread>();
        double mostTrials = 0.0;
        double mostCandidates = 0.0;
        for (WorkUnit current : distributedWorkSet) {
            int total_trials = current.getTotalRequiredTrials();
            double worstExpectations = current.getWorstExpectedCombinationsFromRegion();
            if (mostTrials < (double)total_trials) {
                mostTrials = total_trials;
            }
            if (mostCandidates < worstExpectations) {
                mostCandidates = worstExpectations;
            }
            this.totalProjectedTrials += (long)total_trials;
            this.totalProjectedCandidates = (long)((double)this.totalProjectedCandidates + 0.5 * current.getWorstExpectedCombinationsFromRegion());
            SamplingThread s = new SamplingThread(current, this.searcher, numberOfWorkerThreads, this.outputter);
            threadList.add(s);
            ++numberOfWorkerThreads;
        }
        System.out.println("\n** WORST OFFENDERS **");
        System.out.println("Memory:\n" + mostCandidates / 10000.0);
        System.out.println("Samplings:\n" + mostTrials);
        System.out.println("** WORST OFFENDERS **\n");
        System.out.println("Running " + numberOfWorkerThreads + " search threads, " + this.searcher.userParams.getMaxThreads() + " at a time ... ");
        return threadList;
    }

    public void printProgressAndProjections() {
        double stage1rate = (double)Math.round(this.searcher.stage1Time * 1000L / this.searcher.stage1Trials) / (double)(this.searcher.userParams.getMaxThreads() * 1000);
        double stage2rate = (double)Math.round(this.searcher.stage2Time * 1000L / this.searcher.stage1Candidates) / (double)(this.searcher.userParams.getMaxThreads() * 1000);
        System.out.println("\n***************************************");
        System.out.println("Amortized performance so far: ");
        System.out.println(String.valueOf(stage1rate) + " ms per sample");
        System.out.println("(lookup time included)");
        System.out.println();
        long remainingTrials = this.totalProjectedTrials - this.searcher.stage1Trials;
        long remainingCandidates = Math.max(this.totalProjectedCandidates - this.searcher.stage1Candidates, 0L);
        double remainingStage1Time = (double)Math.round((double)remainingTrials * stage1rate * 100.0 / 3600000.0) / 100.0;
        double remainingStage2Time = (double)Math.round((double)remainingCandidates * stage2rate * 100.0 / 3600000.0) / 100.0;
        double spentTime = (double)Math.round((System.currentTimeMillis() - this.searcher.startTimeMs) * 100L / 3600000L) / 100.0;
        System.out.println("Projected runtime till completion: ");
        System.out.println(String.valueOf(remainingStage1Time + remainingStage2Time) + " hrs remaining");
        System.out.println(String.valueOf(spentTime) + " hrs passed");
        System.out.println(String.valueOf(spentTime + remainingStage1Time + remainingStage2Time) + " hrs total");
        Runtime runtimeObject = Runtime.getRuntime();
        long heap_usage = runtimeObject.totalMemory() - runtimeObject.freeMemory();
        System.out.println("\nHeap usage:\n" + (float)heap_usage / 1000000.0f + " Mb");
        System.out.println("***************************************\n");
        System.out.flush();
    }
}

