#!/usr/bin/env bash
# run command: ./run_all_benchmarks.sh  >benchmark_results.txt 2>&1

stack --resolver lts-22.33 ghc -- --make -threaded -rtsopts -Wall -O2 solver.hs -o solver

benchmarks_dir=./graphs/benchmarks_official
# algos=("DSATUR" "pruning" "parallel_DSATUR" "parallel_pruning" "brute_force")
algos=("DSATUR" "pruning" "parallel_DSATUR" "parallel_pruning")

repeat_num=3
cores_max_num=8

declare -A chrom_nums
chrom_nums=(
    [queen6_6.txt]=7
    [queen5_5.txt]=5
    [queen7_7.txt]=7
    [myciel4.txt]=5
    [complete_10.txt]=10
    [anna.txt]=11
    [petersen.txt]=3
)

offsets=(-1 0)

for g in "$benchmarks_dir"/*; do
    filename=$(basename "$g")
    chromatic_number=${chrom_nums[$filename]}
    # if [[ "$filename" != "myciel4.txt" ]]; then
    #     continue
    # fi
    for algo in "${algos[@]}"; do
        for delta in "${offsets[@]}"; do
            for (( curr_cores=1; curr_cores <= $cores_max_num; curr_cores++ )); do
                if [[ "$algo" != "parallel_DSATUR" && "$algo" != "parallel_pruning" && "$curr_cores" -gt 1 ]]; then
                    continue
                fi
                for (( i=1; i <= $repeat_num; i++ )); do
                    curr_K=$(($chromatic_number + $delta))
                    echo "Current run details= algo:$algo k:$curr_K graph:$g threads:$curr_cores chromatic_number:$chromatic_number trial:$i"
                    time gtimeout 120s ./solver "$g" "$curr_K" "$algo" +RTS -N$curr_cores -s || echo "Failed to finish run, possibly due to timeout."
                    echo "Finished run."
                    echo ""
                    echo ""
                    echo ""
                    echo ""
                done
            done
        done
    done
done