import glob
import os

dimacs_graphs_path = "./graphs/dimacs/raw/"
dimacs_converted_path = "./graphs/dimacs/converted/"


def convert_to_adj_list(file):
    nV = -1
    nE = -1
    edges = {}

    with open(file, 'r') as f:
        for line in f:
            line = line.strip().split()
            if line[0] == 'p':
                nV = int(line[2])
                nE = int(line[3])
            elif line[0] == 'e':
                u = int(line[1]) - 1
                v = int(line[2]) - 1
                if u in edges:
                    edges[u].append(v)
                else:
                    edges[u] = [v]
                
                if v in edges:
                    edges[v].append(u)
                else:
                    edges[v] = [u]
    # print(edges)
    with open(os.path.join(dimacs_converted_path, os.path.basename(file).split(".")[0] + ".txt"), 'w') as f:
        for i in range(nV):
            s = f"{i}: "
            if i in edges:
                for n in sorted(list(set(edges[i]))):
                    s += f"{n} "
            f.write(s + "\n")

for file in glob.glob(os.path.join(dimacs_graphs_path, "*")):
    if os.path.isfile(file):
        convert_to_adj_list(file)