module Main where

import Puzzle
import System.Environment (getArgs)

main :: IO ()
main = do
  args <- getArgs
  let numMoves = case args of
                (x:_) -> x
                []    -> "3"
      board = startBoardByMoves numMoves

  putStrLn $ "Using start board with number of moves: " ++ numMoves
  case iddfspruning board of
    Nothing       -> putStrLn "No solution found."
    Just solMoves -> do
      putStrLn $ "Found solution in " ++ show (length solMoves) ++ " moves:"
      print solMoves
