# Sliding-Tiles-Parallel

### Usage
```
$ cabal build
```

Each different algorithm we wrote has a different executable, allowing running different experiments easily. These are the following algorithms/executables:
- IDDFS sequential: `iddfs`
- IDDFS pruning sequential: `iddfspruning`
- IDA* sequential: `ida`
- IDDFS parallel: `iddfs-par`
- IDDFS pruning parallel: `iddfspruning-par`
- IDA* parallel: `ida-par`

Now, we can run any of these algorithms with a choice of the starting game board. We can select the number of movesets from this list: 3, 8, 16, 17, 30. 36, 38, 40.

With the choice of algorithm and starting configuration, we can run the sequential code (with timing) with
```
$ cabal run algorithn -- numMoves +RTS -s -RTS
```

For example, to run IDDFS on the board with 40 move solution, we can run:
```
$ cabal run iddfs -- 40 +RTS -s -RTS
```

Now, to run in parallel, we add an additional flag that allows us to specify the number of cores we want to use
```
$ cabal run algorithm -- numMoves +RTS -NnumCores -s -RTS
```

For example, to run IDA* in parallel with 8 cores on the board with 17 move solution, we can run:
```
$ cabal run ida-par -- 17 +RTS -N8 -s -RTS
```
### Benchmarks
Benchmarks were run using the commands above.

The final runtime benchmarks were
<img width="898" height="207" alt="Screenshot 2025-12-16 at 7 43 37 PM" src="https://github.com/user-attachments/assets/bdb8d972-5a9e-4ef9-92c8-d8bfb1d4afdf"> <br>
indicating that the most successful parallelized algorithm is IDDFS w/ pruning

The full tables can also be found in the Appendix of the report

