#!/usr/bin/env bash

set -euo pipefail

EXE_DIR="./bin/final-exe"
DATA_DIR="data/"
WARMUP=1
MAX_CORES=8 

# prime of about 64 bits
TP_64=18446744073709551557
# 80% of its sqrt
SQRT_TP_64_80ile=3435973836

stack build --copy-bins

echo "+================================================+
|                                                |
|              ()()         ____                 |
|              (..)        /|o  |                |
|              /\/\       /o|  o|                |
|             c\db/o...  /o_|_o_|                |
|                                                |
|           B E N C H M A R K I N G              |
|                                                |
|================================================|
|     v0.1.0 mousenet®   all rights reserved     |
+================================================+"


hyperfine --warmup $WARMUP --export-csv ${DATA_DIR}tdu.csv "$EXE_DIR tdu $TP_64"

COMMANDS=()
for i in {100,1000,10000,100000,1000000,10000000,100000000,1000000000}; do 
    COMMANDS+=("$EXE_DIR tdi $TP_64 $i")               
done
hyperfine --warmup $WARMUP --export-csv ${DATA_DIR}tdi.csv "${COMMANDS[@]}"

#set at best from prev test
TDI_CMAX=100000

#uses sample params because the algorithm is bad, not worth testing
COMMANDS=()
for i in {1..8}; do
    COMMANDS+=("$EXE_DIR tdip1 $TP_64 100000000 256 +RTS -N$i")
done
hyperfine --warmup $WARMUP --export-csv ${DATA_DIR}tdip1_P.csv "${COMMANDS[@]}"

COMMANDS=()
for i in {4,8,16,32,64,128,256,512}; do
    for j in {16,32,64,128,256,512,1024,2048}; do
        COMMANDS+=("$EXE_DIR tdip2 $TP_64 $TDI_CMAX $i $j +RTS -N${MAX_CORES}")
    done
done
hyperfine --warmup $WARMUP --export-csv ${DATA_DIR}tdip2_NTRPC.csv "${COMMANDS[@]}"

TDIP2_NT=256
TDIP2_RPC=16

COMMANDS=()
for i in {1..8}; do
    COMMANDS+=("$EXE_DIR tdip2 $TP_64 $TDI_CMAX $TDIP2_NT $TDIP2_RPC +RTS -N${i}")
done
hyperfine --warmup $WARMUP --export-csv ${DATA_DIR}tdip2_P.csv "${COMMANDS[@]}"

hyperfine --warmup $WARMUP --export-csv ${DATA_DIR}fermatm.csv "$EXE_DIR fermatm $TP_64 $SQRT_TP_64_80ile"

COMMANDS=()
for i in {8,16,32,64,128,256,512,1024}; do
    for j in {4096,8192,16384,32768,65536,131072,262144,524288}; do
        COMMANDS+=("$EXE_DIR fermatmp $TP_64 $SQRT_TP_64_80ile $i $j +RTS -N${MAX_CORES}")
    done
done
hyperfine --warmup $WARMUP --export-csv ${DATA_DIR}fermatm_NTNC.csv "${COMMANDS[@]}"

FERMAT_NT=256
FERMAT_NC=32768

COMMANDS=()
for i in {1..8}; do
    COMMANDS+=("$EXE_DIR fermatmp $TP_64 $SQRT_TP_64_80ile $FERMAT_NT $FERMAT_NC +RTS -N${i}")
done
hyperfine --warmup $WARMUP --export-csv ${DATA_DIR}fermatm_P.csv "${COMMANDS[@]}"
