### Deterministic Integer Factorization
hazel flaming `^-^` (haf2136/haf2136@columbia.edu)

---

### Intended file Structure

The directory structure should be left as it is out of the box. All commands, unless indicated otherwise, should be run from the `factorization` directory.

### Dependencies

This project depends on `parallel` and `integer-roots`. Running `stack build` should handle these installations automatically. 

Additionally, the benchmarking script depends on `hyperfine`, which can be installed (if using homebrew) with `brew install hyperfine`. 

### Included modules

This project contains three main modules in the `src` directory, `Fermat`, `Lib`, and `TD`. `Lib` can be considered a prelude to `Fermat` and `TD`. 

Fermat contains all Fermat's method related functions and helpers, and TD contains all of trial division's related functions and helpers, specific exports can be found at the top of each module.

### General Execution

`Main` within the `app` directory acts as the interface between these modules and the user, via the command line. For general purpose running, `stack run <...>` can be used to run functions provided in the above modules. 

The avalible options for `<...>` are

```
tdu      N
tdi      N   cMax
tdip1    N   cMax nT    
tdip2    N   cMax nT rpc 
tdip2m   N m cMax nT rpc
fermatm  N m        
fermatmp N m      nT nC
```
where `tdu` is uninformed trial divison, `tdi` is informed trial division, `tdip1` and `tdip2` are different versions of parallelized informed trial division (see report), `tdip2m` is parallelized informed trial division with an additional maximum bound `m`, and `fermatm` and `fermatmp` are serial and parallel Fermat's method with a minimum bound `m`.

Additionally, `cMax` is the maximum wheel circumfrence for informed trial divison, `nT` is the number of parallel worker processes allowed, `rpc` is the number of wheel rotations per worker process, and `nC` is the number of Fermat tests a worker process can do at once.

`-- +RTS -N{} -RTS` will still be required to allow additional core usage. 

### Benchmarking Execution

`stack run` as mentioned above works fine for normal use, however it comes with about 300 ms of overhead, and so for benchmarking purposes, copy the executable to `final/bin` first using `stack build --copy-bins` (this will throw a warning that can be ignored) and then run `./bin/final-exe <...>`. In the included benchmarking bash script, this is done already. `+RTS -N{}` can be added without the `--` required by `stack run`. 

The included benchmarking bash script contains adjustable directory and testing parameters at the top. While `$MAX_CORES` is adjustable, there are some bracket expressions which must be changed manually, i.e. `{1..8}` -> `{1,12}`. The script can be run by `./benchmark.sh` (`chmod` may be necessary to make the script executable). 

All data included in the final presentation and report is included in the `data` folder, `!!` this script will overwrite it `!!`. 

### Example usage: 

```
stack run tdu 1250917091
>>>Just (7757,161263)
```
```
stack run tdi 23092673 10000
>>>Just (1447,15959)
```
```
stack run tdip1 2039752096726071509170170949 100000 64
>>>Just (13313,153215060221292834760773)
```
```
stack run tdip2m 2039752096726071509170170949 50 10 2 2 
>>>Nothing
```
```
stack run tdip2 18446744073709551557 100000 256 16 -- +RTS -N8
>>>Nothing
```
```
stack build --copy-bins

./bin/final-exe fermatm 29435634365157377917235237443420636427590586842327282518673304909348298206846514514192471899039063766057216 2

>>>Just (171568162446175828701138522793853005301493183786094096,171568162446175828701138522793853005301493183786094096)
```

```
stack build --copy-bins

./bin/final-exe fermatmp 18446744073709551557 3435973836 256 32768 +RTS -N6

>>>Nothing
```







