module Main (main) where

import Data.Integer.SAT
  ( Expr (..),
    Prop (..),
    assert,
    checkSat,
    checkSatPar,
    noProps,
    toName,
  )

main :: IO ()
main = do
  let n = 17
      xs = [Var (toName i) | i <- [0 .. n - 1]]

      ternary v = (v :== K 0) :|| (v :== K 1) :|| (v :== K 2)
      ternaryConstraints = foldr ((:&&) . ternary) PTrue xs

      sumConstraint = foldr1 (:+) xs :== K 20

      weightedSum = foldr1 (:+) [fromIntegral (i + 1) :* (xs !! i) | i <- [0 .. n - 1]]

      -- ANALYSIS: With sum=20 and vars in {0,1,2}, what's the minimum weighted sum?
      -- Best case: put all weight in low indices
      -- With 10 twos at indices 0-9: sum=20, weighted = 2*(1+2+...+10) = 110
      -- With 9 twos + 2 ones: sum=20, weighted >= 2*45 + 21 = 111
      -- So minimum achievable weighted sum with sum=20 is exactly 110
      --
      -- Target = 109 is UNSAT (just below minimum), but requires exhaustive search
      weightConstraint = weightedSum :== K 109

      p = ternaryConstraints :&& sumConstraint :&& weightConstraint

  putStrLn "Solving ternary constraint problem..."
  -- print (checkSat (assert p noProps)) -- Expected: Nothing
  print (checkSatPar 8 (assert p noProps))