{-# LANGUAGE BangPatterns #-}
{-# OPTIONS_GHC -Wno-unrecognised-pragmas #-}
{-# HLINT ignore "Use camelCase" #-}

module KnapsackMVar (solve_instance_mvar) where

import Control.Concurrent
import Control.Monad (replicateM, forM_)
import qualified Data.Vector as V

import Types (State(..))
import KnapsackCore (sort_items_vec, build_frontier, dfs_best_value_vec)

solve_instance_mvar
  :: Double
  -> [(Double,Double)]
  -> Int
  -> Int
  -> IO Double
solve_instance_mvar capacity items_list depth_limit n_workers = do
  let items_vec       = sort_items_vec items_list
      frontier_states = build_frontier capacity depth_limit items_vec

  best_mvar <- newMVar 0
  work_mvar <- newMVar frontier_states

  done_vars <- replicateM n_workers newEmptyMVar

  forM_ done_vars $ \done_var -> do
    _ <- forkFinally
          (worker_loop capacity items_vec best_mvar work_mvar)
          (\_ -> putMVar done_var ())
    pure ()

  mapM_ takeMVar done_vars
  readMVar best_mvar


worker_loop
  :: Double
  -> V.Vector (Double,Double)
  -> MVar Double
  -> MVar [State]
  -> IO ()
worker_loop capacity items_vec best_mvar work_mvar = do
  m_task <- modifyMVar work_mvar $ \tasks ->
    case tasks of
      []     -> pure ([], Nothing)
      (t:ts) -> pure (ts, Just t)

  case m_task of
    Nothing -> pure ()
    Just st -> do
      best_global <- readMVar best_mvar
      let dfs = dfs_best_value_vec capacity items_vec
          !local_best =
            dfs (state_level st) (state_weight st) (state_value st)
                (max best_global (state_value st))

      modifyMVar_ best_mvar $ \old_best -> pure (max old_best local_best)
      worker_loop capacity items_vec best_mvar work_mvar




