module Main (main) where

import System.Environment (getArgs)
import Control.Monad (forM_)

import ReadInstances
import KnapsackSeq (knapsackSeq)
import KnapsackCore (sort_items_vec, dfs_best_value_vec)
import KnapsackIORefPar (solve_instance_ioref)
import KnapsackMVar (solve_instance_mvar)
import KnapsackStealPool (solve_instance_steal)

main :: IO ()
main = do
  args <- getArgs
  case args of

    ------------------------------------------------------------
    -- NEW: Vector-based sequential solver (your latest version)
    ------------------------------------------------------------
    ["seq", input_root] -> do
      insts <- readAllInstances input_root
      forM_ insts $ \inst -> do
        let best_val = knapsackSeq (capacity inst) (items inst)
        putStrLn $ inst_name inst ++ "," ++ show best_val

    ------------------------------------------------------------
    -- Existing "core" (core vector DFS)
    ------------------------------------------------------------
    ["core", input_root] -> do
      insts <- readAllInstances input_root
      forM_ insts $ \inst -> do
        let items_vec = sort_items_vec (items inst)
            best_val  = dfs_best_value_vec
                          (capacity inst)
                          items_vec
                          0 0 0 0
        putStrLn $ inst_name inst ++ "," ++ show best_val

    ------------------------------------------------------------
    -- IORef parallel
    ------------------------------------------------------------
    ["ioref", input_root, depth_str, workers_str] -> do
      insts <- readAllInstances input_root
      let depth_limit = read depth_str
          n_workers   = read workers_str
      forM_ insts $ \inst -> do
        best_val <- solve_instance_ioref
                      (capacity inst)
                      (items inst)
                      depth_limit
                      n_workers
        putStrLn $ inst_name inst ++ "," ++ show best_val

    ------------------------------------------------------------
    -- MVar parallel
    ------------------------------------------------------------
    ["mvar", input_root, depth_str, workers_str] -> do
      insts <- readAllInstances input_root
      let depth_limit = read depth_str
          n_workers   = read workers_str
      forM_ insts $ \inst -> do
        best_val <- solve_instance_mvar
                      (capacity inst)
                      (items inst)
                      depth_limit
                      n_workers
        putStrLn $ inst_name inst ++ "," ++ show best_val

    ------------------------------------------------------------
    -- Work-stealing pool
    ------------------------------------------------------------
    ["steal", input_root, depth_str, workers_str] -> do
      insts <- readAllInstances input_root
      let depth_limit = read depth_str
          n_workers   = read workers_str
      forM_ insts $ \inst -> do
        best_val <- solve_instance_steal
                      (capacity inst)
                      (items inst)
                      depth_limit
                      n_workers
        putStrLn $ inst_name inst ++ "," ++ show best_val

    ------------------------------------------------------------
    -- Usage
    ------------------------------------------------------------
    _ -> do
      putStrLn "Usage:"
      putStrLn "  knapsack seq   <input_root>                # Vector-based KnapsackSeq"
      putStrLn "  knapsack core  <input_root>                # Core DFS"
      putStrLn "  knapsack ioref <input_root> <depth> <N>"
      putStrLn "  knapsack mvar  <input_root> <depth> <N>"
      putStrLn "  knapsack steal <input_root> <depth> <N>"
