module Main (main) where

import Board 
import SequentialMCTS
import ParallelMCTS
import Data.Maybe (fromMaybe, listToMaybe)
import System.Environment (getArgs)

main :: IO ()
main = do
  args <- getArgs
  let iterations = read (fromMaybe "10" (listToMaybe args))

  -- let root = SequentialMCTS.rootNode createEmptyBoard Red
  -- final <- SequentialMCTS.mctsAlgo root 1 iterations
  -- let best = SequentialMCTS.bestMove final

  let root = ParallelMCTS.rootNode createEmptyBoard Red
  final <- ParallelMCTS.mctsAlgo root 1 8 iterations
  let best = ParallelMCTS.bestMove final

  print best