#include "Note.h"
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

// Global variables
NoteEvent *note_events = NULL;
int note_event_count = 0;

int load_note_file(const char *path) {
    FILE *f = fopen(path, "r");
    if (!f) return -1;

    // Count the number of valid lines
    int lines = 0;
    char buf[128];
    while (fgets(buf, sizeof(buf), f)) {
        if (buf[0] == '#' || buf[0] == '\n') continue;
        lines++;
    }
    if (lines == 0) {
        fclose(f);
        return -1;
    }

    // Allocate memory
    note_events = malloc(lines * sizeof(NoteEvent));
    if (!note_events) {
        fclose(f);
        return -1;
    }

    // Rewind and parse
    rewind(f);
    int idx = 0;
    while (fgets(buf, sizeof(buf), f)) {
        if (buf[0] == '#' || buf[0] == '\n') continue;
        int t, tr;
        if (sscanf(buf, "%d , %d", &t, &tr) == 2) {
            note_events[idx].time_ms = t;
            note_events[idx].track = tr;
            idx++;
        }
    }
    fclose(f);

    note_event_count = idx;
    return 0;
}

int load_note_file_bin(const char *path) {
    // printf("Loading binary note file: %s\n", path);
    FILE *f = fopen(path, "rb");
    if (!f) return -1;

    // Get file size
    fseek(f, 0, SEEK_END);
    long size = ftell(f);
    rewind(f);

    if (size % sizeof(NoteEvent) != 0) {
        fclose(f);
        return -1;  // Corrupt file or incorrect format
    }

    int count = size / sizeof(NoteEvent);
    note_events = malloc(size);
    if (!note_events) {
        fclose(f);
        return -1;
    }

    if (fread(note_events, sizeof(NoteEvent), count, f) != count) {
        free(note_events);
        fclose(f);
        return -1;
    }

    fclose(f);
    note_event_count = count;
    return 0;
}

void unload_note_file(void) {
    free(note_events);
    note_events = NULL;
    note_event_count = 0;
}

NoteAnimation POS1 = {
    .frames = {
        {255, 0, 15, 6},
        {255, 0, 15, 6},
        {255, 0, 15, 6},
        {255, 0, 15, 6},
        {255, 0, 15, 6},
        {255, 1, 15, 6},
        {254, 1, 15, 6},
        {254, 1, 15, 6},
        {254, 2, 15, 6},
        {253, 3, 16, 6},
        {253, 4, 16, 6},
        {252, 6, 16, 6},
        {251, 7, 16, 7},
        {250, 9, 17, 7},
        {248, 12, 17, 7},
        {247, 14, 18, 7},
        {245, 17, 19, 7},
        {243, 21, 19, 8},
        {241, 25, 20, 8},
        {238, 29, 21, 8},
        {235, 34, 22, 9},
        {232, 39, 23, 9},
        {229, 45, 24, 9},
        {225, 52, 26, 10},
        {221, 59, 27, 11},
        {217, 66, 29, 11},
        {212, 74, 30, 12},
        {207, 83, 32, 12},
        {201, 93, 34, 13},
        {195, 103, 36, 14},
        {189, 114, 38, 15},
        {182, 126, 41, 16},
        {175, 139, 43, 17},
        {167, 152, 46, 18},
        {158, 167, 49, 19},
        {150, 182, 52, 20},
        {140, 198, 55, 21},
        {131, 215, 59, 23},
        {120, 233, 63, 24},
        {109, 251, 66, 25},
        {98, 271, 70, 27},
        {86, 292, 75, 29},
        {73, 314, 79, 30},
        {60, 337, 84, 32},
        {46, 361, 89, 34},
        {31, 386, 94, 36},
        {16, 413, 99, 38},
        {0, 440, 105, 40},
    }
};

NoteAnimation POS2 = {
    .frames = {
        {270, 0, 15, 6},
        {270, 0, 15, 6},
        {270, 0, 15, 6},
        {270, 0, 15, 6},
        {270, 0, 15, 6},
        {270, 1, 15, 6},
        {270, 1, 15, 6},
        {269, 1, 15, 6},
        {269, 2, 15, 6},
        {269, 3, 16, 6},
        {268, 4, 16, 6},
        {268, 6, 16, 6},
        {267, 7, 16, 7},
        {266, 9, 17, 7},
        {266, 12, 17, 7},
        {264, 14, 18, 7},
        {263, 17, 18, 7},
        {262, 21, 19, 8},
        {260, 25, 20, 8},
        {259, 29, 21, 8},
        {257, 34, 22, 9},
        {255, 39, 23, 9},
        {253, 45, 24, 9},
        {250, 52, 25, 10},
        {247, 59, 26, 11},
        {244, 66, 28, 11},
        {241, 74, 29, 12},
        {238, 83, 31, 12},
        {234, 93, 33, 13},
        {230, 103, 35, 14},
        {226, 114, 37, 15},
        {221, 126, 39, 16},
        {216, 139, 42, 17},
        {211, 152, 44, 18},
        {206, 167, 47, 19},
        {200, 182, 50, 20},
        {194, 198, 53, 21},
        {187, 215, 56, 23},
        {180, 233, 60, 24},
        {173, 251, 64, 25},
        {165, 271, 67, 27},
        {157, 292, 71, 29},
        {149, 314, 76, 30},
        {140, 337, 80, 32},
        {131, 361, 85, 34},
        {121, 386, 90, 36},
        {111, 413, 95, 38},
        {100, 440, 100, 40},
    }
};

NoteAnimation POS3 = {
    .frames = {
        {285, 0, 15, 6},
        {285, 0, 15, 6},
        {285, 0, 15, 6},
        {285, 0, 15, 6},
        {285, 0, 15, 6},
        {285, 1, 15, 6},
        {285, 1, 15, 6},
        {285, 1, 15, 6},
        {285, 2, 15, 6},
        {284, 3, 16, 6},
        {284, 4, 16, 6},
        {284, 6, 16, 6},
        {284, 7, 16, 7},
        {283, 9, 17, 7},
        {283, 12, 17, 7},
        {282, 14, 18, 7},
        {282, 17, 18, 7},
        {281, 21, 19, 8},
        {280, 25, 19, 8},
        {279, 29, 20, 8},
        {278, 34, 21, 9},
        {277, 39, 22, 9},
        {276, 45, 23, 9},
        {275, 52, 24, 10},
        {274, 59, 26, 11},
        {272, 66, 27, 11},
        {271, 74, 29, 12},
        {269, 83, 30, 12},
        {267, 93, 32, 13},
        {265, 103, 34, 14},
        {263, 114, 36, 15},
        {261, 126, 38, 16},
        {258, 139, 40, 17},
        {256, 152, 43, 18},
        {253, 167, 45, 19},
        {250, 182, 48, 20},
        {247, 198, 51, 21},
        {244, 215, 54, 23},
        {240, 233, 57, 24},
        {236, 251, 61, 25},
        {233, 271, 64, 27},
        {229, 292, 68, 29},
        {224, 314, 72, 30},
        {220, 337, 76, 32},
        {215, 361, 81, 34},
        {210, 386, 85, 36},
        {205, 413, 90, 38},
        {200, 440, 95, 40},
    }
};

NoteAnimation POS4 = {
    .frames = {
        {300, 0, 15, 6},
        {300, 0, 15, 6},
        {300, 0, 15, 6},
        {300, 0, 15, 6},
        {300, 0, 15, 6},
        {300, 1, 15, 6},
        {300, 1, 15, 6},
        {300, 1, 15, 6},
        {300, 2, 15, 6},
        {300, 3, 16, 6},
        {300, 4, 16, 6},
        {300, 6, 16, 6},
        {300, 7, 16, 7},
        {300, 9, 17, 7},
        {300, 12, 17, 7},
        {300, 14, 18, 7},
        {300, 17, 18, 7},
        {300, 21, 19, 8},
        {300, 25, 19, 8},
        {300, 29, 20, 8},
        {300, 34, 21, 9},
        {300, 39, 22, 9},
        {300, 45, 23, 9},
        {300, 52, 24, 10},
        {300, 59, 26, 11},
        {300, 66, 27, 11},
        {300, 74, 29, 12},
        {300, 83, 30, 12},
        {300, 93, 32, 13},
        {300, 103, 34, 14},
        {300, 114, 36, 15},
        {300, 126, 38, 16},
        {300, 139, 40, 17},
        {300, 152, 43, 18},
        {300, 167, 45, 19},
        {300, 182, 48, 20},
        {300, 198, 51, 21},
        {300, 215, 54, 23},
        {300, 233, 57, 24},
        {300, 251, 61, 25},
        {300, 271, 64, 27},
        {300, 292, 68, 29},
        {300, 314, 72, 30},
        {300, 337, 76, 32},
        {300, 361, 81, 34},
        {300, 386, 85, 36},
        {300, 413, 90, 38},
        {300, 440, 95, 40},
    }
};

NoteAnimation POS5 = {
    .frames = {
        {315, 0, 15, 6},
        {315, 0, 15, 6},
        {315, 0, 15, 6},
        {315, 0, 15, 6},
        {315, 0, 15, 6},
        {315, 1, 15, 6},
        {315, 1, 15, 6},
        {315, 1, 15, 6},
        {315, 2, 15, 6},
        {316, 3, 16, 6},
        {316, 4, 16, 6},
        {316, 6, 16, 6},
        {316, 7, 16, 7},
        {317, 9, 17, 7},
        {317, 12, 17, 7},
        {318, 14, 18, 7},
        {318, 17, 18, 7},
        {319, 21, 19, 8},
        {320, 25, 20, 8},
        {321, 29, 21, 8},
        {322, 34, 22, 9},
        {323, 39, 23, 9},
        {324, 45, 24, 9},
        {325, 52, 25, 10},
        {326, 59, 26, 11},
        {328, 66, 28, 11},
        {329, 74, 29, 12},
        {331, 83, 31, 12},
        {333, 93, 33, 13},
        {335, 103, 35, 14},
        {337, 114, 37, 15},
        {339, 126, 39, 16},
        {342, 139, 42, 17},
        {344, 152, 44, 18},
        {347, 167, 47, 19},
        {350, 182, 50, 20},
        {353, 198, 53, 21},
        {356, 215, 56, 23},
        {360, 233, 60, 24},
        {364, 251, 64, 25},
        {367, 271, 67, 27},
        {371, 292, 71, 29},
        {376, 314, 76, 30},
        {380, 337, 80, 32},
        {385, 361, 85, 34},
        {390, 386, 90, 36},
        {395, 413, 95, 38},
        {400, 440, 100, 40},
    }
};

NoteAnimation POS6 = {
    .frames = {
        {330, 0, 15, 6},
        {330, 0, 15, 6},
        {330, 0, 15, 6},
        {330, 0, 15, 6},
        {330, 0, 15, 6},
        {330, 1, 15, 6},
        {330, 1, 15, 6},
        {331, 1, 15, 6},
        {331, 2, 15, 6},
        {331, 3, 16, 6},
        {332, 4, 16, 6},
        {332, 6, 16, 6},
        {333, 7, 16, 7},
        {334, 9, 17, 7},
        {334, 12, 17, 7},
        {336, 14, 18, 7},
        {337, 17, 19, 7},
        {338, 21, 19, 8},
        {340, 25, 20, 8},
        {341, 29, 21, 8},
        {343, 34, 22, 9},
        {345, 39, 23, 9},
        {347, 45, 24, 9},
        {350, 52, 26, 10},
        {353, 59, 27, 11},
        {356, 66, 29, 11},
        {359, 74, 30, 12},
        {362, 83, 32, 12},
        {366, 93, 34, 13},
        {370, 103, 36, 14},
        {374, 114, 38, 15},
        {379, 126, 41, 16},
        {384, 139, 43, 17},
        {389, 152, 46, 18},
        {394, 167, 49, 19},
        {400, 182, 52, 20},
        {406, 198, 55, 21},
        {413, 215, 59, 23},
        {420, 233, 63, 24},
        {427, 251, 66, 25},
        {435, 271, 70, 27},
        {443, 292, 75, 29},
        {451, 314, 79, 30},
        {460, 337, 84, 32},
        {469, 361, 89, 34},
        {479, 386, 94, 36},
        {489, 413, 99, 38},
        {500, 440, 105, 40},
    }
};