/*
 * Copyright (c) 2000, Ping Pan and Henning Schulzrinne
 *	All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Initially written by Ping Pan, Columbia University/Bell Labs, February 2000.
 * We acknowledge Bell Labs for support. Please forward bug fixes,enhancements 
 * and questions to pingpan@cs.columbia.edu.
 */

#include <sys/param.h>
#include <sys/protosw.h>
#include <sys/domain.h>
#include <sys/socket.h>
#include <sys/socketvar.h>
#include <sys/kernel.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <netinet/ip_var.h>
#include <netipopt/ipopt_var.h>

/* 
 * For more info on new protocol/protocol-family initialization,
 * check TCP/IP Illustrated, Vol.2, Section 7.5.
 * Long live Stevens!
 */


static struct pr_usrreqs nousrreqs;	/* dummy process request */


/* 
 * A new protosw structure for all the 'protocols' in AF_IPOPTION.
 * Each IP option type represents a new 'protocol'.
 *
 * Note: don't move the first entry, it's reserved for unknown
 * protocols (set in ipopt_reg_proto()).
 */

struct protosw	ipoptsw[] = {
{ 0,		&ipoptdomain,	0,		PR_ATOMIC|PR_ADDR,
  null_input,	0,		0,		0,
  0,
  0,		0,		0,		0,
  &nousrreqs
},
{ SOCK_RAW,	&ipoptdomain,	IPOPT_RA,	PR_ATOMIC|PR_ADDR,
  ra_input,	0,		0,		ipopt_ctloutput,
  0,
  0,		0,		0,		0,
  &ipopt_usrreqs
},
{ SOCK_RAW,	&ipoptdomain,	IPOPT_RR,	PR_ATOMIC|PR_ADDR,
  rr_input,	0,		0,		ipopt_ctloutput,
  0,
  0,		0,		0,		0,
  &ipopt_usrreqs
},
{ SOCK_RAW,	&ipoptdomain,	IPOPT_TS,	PR_ATOMIC|PR_ADDR,
  ts_input,	0,		0,		ipopt_ctloutput,
  0,
  0,		0,		0,		0,
  &ipopt_usrreqs
},
{ SOCK_RAW,	&ipoptdomain,	IPOPT_SECURITY,	PR_ATOMIC|PR_ADDR,
  security_input,	0,		0,		ipopt_ctloutput,
  0,
  0,		0,		0,		0,
  &ipopt_usrreqs
},
{ SOCK_RAW,	&ipoptdomain,	IPOPT_LSRR,	PR_ATOMIC|PR_ADDR,
  lsrr_input,	0,		0,		ipopt_ctloutput,
  0,
  0,		0,		0,		0,
  &ipopt_usrreqs
},
{ SOCK_RAW,	&ipoptdomain,	IPOPT_SSRR,	PR_ATOMIC|PR_ADDR,
  ssrr_input,	0,		0,		ipopt_ctloutput,
  0,
  0,		0,		0,		0,
  &ipopt_usrreqs
},
};


/* 
 * A new domain for the AF_IPOPTION.
 */

static struct domain 	ipoptdomain = {
	AF_IPOPTION,	"ip-option",	ipopt_init,	0,	0,
	ipoptsw, &ipoptsw[sizeof(ipoptsw)/sizeof(ipoptsw[0])],	0,
	0,	0,	0};

DOMAIN_SET(ipopt);

