package edu.columbia.preju.xml;

import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;

import edu.columbia.preju.configuration.JustificationConfiguration;
import edu.columbia.preju.configuration.JustificationConfigurationImpl;
import edu.columbia.preju.generator.JustificationGenerator;
import edu.columbia.preju.keyFeatureSelection.KeyFeatureSelection;
import edu.columbia.preju.prediction.Prediction;
import edu.columbia.preju.roleAssignment.RoleAssignment;
import edu.columbia.preju.roleAssignment.TableRoleAssignment;
import edu.columbia.preju.roleAssignment.discretizer.Discretizer;

public class XmlConfigurationFactory {

	public static JustificationConfiguration getConfiguration(String configurationXmlFile, Prediction prediction) {
		
		Document doc = build(configurationXmlFile);
		
		Element root = doc.getRootElement();
		
		RoleAssignment roleAssignment = parseRoleAssignment(root.getChild("roleAssignment"), prediction);
		KeyFeatureSelection keyFeatureSelection = parseKeyFeatureSelection(root.getChild("keyFeatureSelection"), prediction);
		JustificationGenerator justificationGenerator = parseJustificationGenerator(root.getChild("justificationGenerator"), prediction);
		
		return new JustificationConfigurationImpl(roleAssignment, keyFeatureSelection, justificationGenerator);
	}


	private static JustificationGenerator parseJustificationGenerator(Element element, Prediction prediction) {
		String claz = element.getAttributeValue("factory");
		try {
			@SuppressWarnings("unchecked")
			XmlObjectFactory<JustificationGenerator> generatorFactory = (XmlObjectFactory<JustificationGenerator>) Class.forName(claz).newInstance();
			return generatorFactory.createFromXml(element, prediction);
		} catch (Exception e) {
			throw new RuntimeException("Could not instantiate justification generator of class " + claz, e);
		}
	}


	private static KeyFeatureSelection parseKeyFeatureSelection(Element element, Prediction prediction) {
		String claz = element.getAttributeValue("factory");
		try {
			@SuppressWarnings("unchecked")
			XmlObjectFactory<KeyFeatureSelection> selectionFactory = (XmlObjectFactory<KeyFeatureSelection>) Class.forName(claz).newInstance();
			return selectionFactory.createFromXml(element, prediction);
		} catch (Exception e) {
			throw new RuntimeException("Could not instantiate justification generator of class " + claz, e);
		}
	}


	private static RoleAssignment parseRoleAssignment(Element element, Prediction prediction) {
		Discretizer importanceDiscretizer = parseDiscretizer(element.getChild("importanceDiscretizer"), prediction);
//		Discretizer effectDiscretizer = parseDiscretizer(element.getChild("effectDiscretizer"));
//		return effectDiscretizer == null ? new TableRoleAssignment(importanceDiscretizer) : new TableRoleAssignment(importanceDiscretizer, effectDiscretizer);
		return new TableRoleAssignment(importanceDiscretizer);
	}


	private static Discretizer parseDiscretizer(Element element, Prediction prediction) {
		String claz = element.getAttributeValue("factory");
		try {
			@SuppressWarnings("unchecked")
			XmlObjectFactory<Discretizer> discretizerFactory = (XmlObjectFactory<Discretizer>) Class.forName(claz).newInstance();
			return discretizerFactory.createFromXml(element, prediction);
		} catch (Exception e) {
			throw new RuntimeException("Could not instantiate discretizer of class " + claz, e);
		}
	}


	private static Document build(String predictionXmlFile) {
		try {
			return new SAXBuilder().build(predictionXmlFile);
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

}
