package edu.columbia.preju.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import ob.core.Feature;
import edu.columbia.preju.prediction.Prediction;

public class PrejuUtils {

	public static List<Feature> getEffectSortedFeatures(final Prediction prediction) {
		List<Feature> sortedFeatures = new ArrayList<Feature>(prediction.getFeatures());
		Collections.sort(sortedFeatures, new Comparator<Feature>() {
			public int compare(Feature o1, Feature o2) {
				return - Double.valueOf(Math.abs(prediction.getEffect(o1).getDouble())).compareTo(Double.valueOf(Math.abs(prediction.getEffect(o2).getDouble())));
			}
		});
		
		return sortedFeatures;
	}

	public static List<Feature> getImportanceSortedFeatures(final Prediction prediction) {
		List<Feature> sortedFeatures = new ArrayList<Feature>(prediction.getFeatures());
		Collections.sort(sortedFeatures, new Comparator<Feature>() {
			public int compare(Feature o1, Feature o2) {
				return - Double.valueOf(Math.abs(prediction.getImportance(o1).getDouble())).compareTo(Double.valueOf(Math.abs(prediction.getImportance(o2).getDouble())));
			}
		});
		
		return sortedFeatures;
	}

}
