package edu.columbia.preju.roleAssignment.discretizer;

import org.jdom2.Element;

import edu.columbia.preju.core.Measure;
import edu.columbia.preju.prediction.Prediction;
import edu.columbia.preju.roleAssignment.Discretization;
import edu.columbia.preju.roleAssignment.DiscretizationImpl;
import edu.columbia.preju.xml.XmlObjectFactory;

/**
 * @author Or
 *
 */
public class ThresholdDiscretizer implements Discretizer, XmlObjectFactory<Discretizer> {
	
	private double _threshold;
	
	public ThresholdDiscretizer() {
		// empty constructor for use as XmlObjectFactory
	}

	public ThresholdDiscretizer(double threshold) {
		_threshold = threshold;
	}

	@Override
	public Discretization getDiscretization(Measure measure) {
		return new DiscretizationImpl(
				measure.getDouble() > 0, 
				Math.abs(measure.getDouble()) > _threshold
				);
	}

	@Override
	public double getHighThreshold() {
		return _threshold;
	}

	@Override
	public double getLowThreshold() {
		return _threshold;
	}

	@Override
	public Discretizer createFromXml(Element element, Prediction prediction) {
		double threshold = Double.parseDouble(element.getChildTextNormalize("threshold"));
		return new ThresholdDiscretizer(threshold);
	}

}
