package edu.columbia.preju.roleAssignment.discretizer;

import edu.columbia.preju.core.Measure;
import edu.columbia.preju.roleAssignment.Discretization;
import edu.columbia.preju.roleAssignment.DiscretizationImpl;

public class MidwayDiscretizer implements Discretizer {

	private Discretizer _reference;
	
	public MidwayDiscretizer(Discretizer reference) {
		_reference = reference;
	}

	@Override
	public Discretization getDiscretization(Measure measure) {
		return new DiscretizationImpl(
				measure.getDouble() > 0, 
				Math.abs(measure.getDouble()) > getMidwayThreshold()
				);
	}

	private double getMidwayThreshold() {
		return (_reference.getHighThreshold() + _reference.getLowThreshold()) / 2;
	}

	@Override
	public double getHighThreshold() {
		throw new UnsupportedOperationException();
	}

	@Override
	public double getLowThreshold() {
		throw new UnsupportedOperationException();
	}

}
