package edu.columbia.preju.roleAssignment.discretizer;

import java.util.List;

import org.jdom2.Element;

import ob.core.Feature;
import edu.columbia.preju.core.Measure;
import edu.columbia.preju.prediction.Prediction;
import edu.columbia.preju.roleAssignment.Discretization;
import edu.columbia.preju.roleAssignment.DiscretizationImpl;
import edu.columbia.preju.util.PrejuUtils;
import edu.columbia.preju.xml.XmlObjectFactory;

public class ImportancePercentageDiscretizer implements Discretizer, XmlObjectFactory<Discretizer> {

	private double _percentage;
	
	private double _highThreshold;
	private double _lowThreshold;

	public ImportancePercentageDiscretizer() {
		// empty constructor for use as XmlObjectFactory
	}

	public ImportancePercentageDiscretizer(double percentage, Prediction prediction) {
		_percentage = percentage;
		
		double totalImportance = getTotalImportance(prediction);
		List<Feature> importanceSortedFeatures = PrejuUtils.getImportanceSortedFeatures(prediction);
		
		double cumulativeImportance = 0;
		for (int i=0; i<importanceSortedFeatures.size(); i++) {
			cumulativeImportance += Math.abs(prediction.getImportance(importanceSortedFeatures.get(i)).getDouble());
			
			if (cumulativeImportance / totalImportance >= _percentage || i==importanceSortedFeatures.size() - 1) {
				_highThreshold = Math.abs(prediction.getImportance(importanceSortedFeatures.get(i)).getDouble());
				_lowThreshold = i==importanceSortedFeatures.size() - 1 ? 
						0.0
						: Math.abs(prediction.getImportance(importanceSortedFeatures.get(i+1)).getDouble());
				break;
			}
		}
	}

	private double getTotalImportance(Prediction prediction) {
		double total = 0;
		for (Feature feature : prediction.getFeatures()) {
			total += Math.abs(prediction.getImportance(feature).getDouble());
		}
		return total;
	}

	@Override
	public Discretization getDiscretization(Measure measure) {
		return new DiscretizationImpl(
				measure.getDouble() > 0, 
				Math.abs(measure.getDouble()) >= _highThreshold
				);
	}

	@Override
	public double getHighThreshold() {
		return _highThreshold;
	}

	@Override
	public double getLowThreshold() {
		return _lowThreshold;
	}

	public double getPercentage() {
		return _percentage;
	}

	@Override
	public Discretizer createFromXml(Element element, Prediction prediction) {
		double percentage = Double.parseDouble(element.getChildTextNormalize("percentage"));
		return new ImportancePercentageDiscretizer(percentage, prediction);
	}

}
