package edu.columbia.preju.roleAssignment.discretizer;

import java.util.List;

import org.jdom2.Element;

import ob.core.Feature;
import edu.columbia.preju.core.Measure;
import edu.columbia.preju.prediction.Prediction;
import edu.columbia.preju.roleAssignment.Discretization;
import edu.columbia.preju.roleAssignment.DiscretizationImpl;
import edu.columbia.preju.util.PrejuUtils;
import edu.columbia.preju.xml.XmlObjectFactory;

public class FixedNumberDiscretizer implements Discretizer, XmlObjectFactory<Discretizer> {

	private int _n;
	private double _highThreshold;
	private double _lowThreshold;
	
	public FixedNumberDiscretizer() {
		// empty constructor for use as XmlObjectFactory
	}
	
	public FixedNumberDiscretizer(int n, Prediction prediction) {
		_n = n;
		if (_n == 0) throw new RuntimeException("N cannot be zero");

		int thresholdIndex = prediction.getFeatures().size() > _n - 1 ? _n - 1 : prediction.getFeatures().size() - 1;
		
		List<Feature> importanceSortedFeatures = PrejuUtils.getImportanceSortedFeatures(prediction);
		_highThreshold = prediction.getImportance(importanceSortedFeatures.get(thresholdIndex)).getDouble();
		_lowThreshold = thresholdIndex == prediction.getFeatures().size() - 1 ? 
				0.0 
				: prediction.getImportance(importanceSortedFeatures.get(thresholdIndex + 1)).getDouble();
	}
	
	@Override
	public Discretization getDiscretization(Measure measure) {
		return new DiscretizationImpl(
				measure.getDouble() > 0, 
				Math.abs(measure.getDouble()) >= _highThreshold
				);
	}

	public int getN() {
		return _n;
	}

	public double getHighThreshold() {
		return _highThreshold;
	}

	public double getLowThreshold() {
		return _lowThreshold;
	}

	@Override
	public Discretizer createFromXml(Element element, Prediction prediction) {
		int n = Integer.parseInt(element.getChildTextNormalize("n"));
		return new FixedNumberDiscretizer(n, prediction);
	}
	
}
