package edu.columbia.preju.roleAssignment;

import edu.columbia.preju.core.NarrativeRole;
import edu.columbia.preju.prediction.Prediction;
import edu.columbia.preju.roleAssignment.discretizer.Discretizer;
import edu.columbia.preju.roleAssignment.discretizer.MidwayDiscretizer;
import ob.core.Feature;

/**
 * @author Or
 *
 */
public class TableRoleAssignment implements RoleAssignment {

	private Discretizer _effectDiscretizer;
	private Discretizer _importanceDiscretizer;
	
	public TableRoleAssignment(Discretizer importanceDiscretizer) {
		this(importanceDiscretizer, new MidwayDiscretizer(importanceDiscretizer));
	}

	protected TableRoleAssignment(Discretizer importanceDiscretizer, Discretizer effectDiscretizer) {
		_importanceDiscretizer = importanceDiscretizer;
		_effectDiscretizer = effectDiscretizer;
	}

	@Override
	public NarrativeRole getNarrativeRole(Feature feature, Prediction prediction) {
		Discretization importanceDiscretization = getImportanceDiscretization(feature, prediction);
		Discretization effectDiscretization = getEffectDiscretization(feature, prediction);
		
		if (importanceDiscretization.isHigh()) {
			if (importanceDiscretization.isPositive()) {
				// importance: high positive (we expect evidence to be present)
				if (effectDiscretization.isHigh()) {
					if (effectDiscretization.isPositive()) {
						// effect: high positive (evidence is indeed present)
						return NarrativeRole.ExpectedEvidence;
					}
					else {
						// effect: high negative (counter evidence instead of expected evidence)
						return NarrativeRole.ContrarianCounterEvidence;
					}
				}
				else {
					// effect: low (no evidence despite expectation)
					return NarrativeRole.MissingEvidence;
				}
			}
			else {
				// importance: high negative (we expect counter-evidence to be present)
				if (effectDiscretization.isHigh()) {
					if (effectDiscretization.isPositive()) {
						// effect: high positive (evidence instead of expected counter-evidence)
						return NarrativeRole.ContrarianEvidence;
					}
					else {
						// effect: high negative (counter-evidence is indeed present)
						return NarrativeRole.ExpectedCounterEvidence;
					}
				}
				else {
					// effect: low (no counter-evidence despite expectation)
					return NarrativeRole.MissingCounterEvidence;
				}
			}
		}
		else {
			// importance: low (we do not expect evidence or counter-evidence to be present)
			if (effectDiscretization.isHigh()) {
				if (effectDiscretization.isPositive()) {
					// effect: high positive (evidence despite the expectation)
					return NarrativeRole.ExceptionalEvidence;
				}
				else {
					// effect: high negative (counter-evidence despite the expectation)
					return NarrativeRole.ExceptionalCounterEvidence;
				}
			}
			else {
				// effect: low (no evidence or counter-evidence, as expected)
				return NarrativeRole.Negligible;
			}
		}
		
		
	}

	private Discretization getEffectDiscretization(Feature feature, Prediction prediction) {
		return _effectDiscretizer.getDiscretization(prediction.getEffect(feature));
	}

	private Discretization getImportanceDiscretization(Feature feature, Prediction prediction) {
		return _importanceDiscretizer.getDiscretization(prediction.getImportance(feature));
	}
	
}
