package edu.columbia.preju.prediction.classifier;

import java.util.Collection;
import java.util.Map;

import ob.core.Feature;
import ob.core.Value;
import edu.columbia.preju.core.Effect;
import edu.columbia.preju.core.Importance;

public class SimpleClassifierModelInfo implements ClassifierModelInfo {

	private String _modelName;
	
	private Map<Integer, Value> _priorMap;
	private Map<Integer, Map<Feature, Importance>> _importanceMap;
	private Map<Integer, Map<Feature, Effect>> _effectMap;
	
	public SimpleClassifierModelInfo(String modelName, Map<Integer, Value> priorMap, Map<Integer, Map<Feature, Importance>> importanceMap, Map<Integer, Map<Feature, Effect>> effectMap) {
		_modelName = modelName;
		_priorMap = priorMap;
		_importanceMap = importanceMap;
		_effectMap = effectMap;
	}

	@Override
	public Collection<Feature> getFeatures() {
		return _importanceMap.get(0).keySet();
	}

	@Override
	public Importance getImportance(Feature feature, int classIndex) {
		return _importanceMap.get(classIndex).get(feature);
	}

	@Override
	public Effect getEffect(Feature feature, int classIndex, Map<Feature, Value> featureValues) {
		return _effectMap.get(classIndex).get(feature);
	}

	@Override
	public String getModelName() {
		return _modelName;
	}

	@Override
	public Value getPrior(int classIndex) {
		return _priorMap.get(classIndex);
	}

	@Override
	public int getNumClasses() {
		return _importanceMap.size();
	}

}
