package edu.columbia.preju.prediction.classifier;

import java.util.Collection;
import java.util.Map;

import edu.columbia.preju.core.Effect;
import edu.columbia.preju.core.Importance;
import ob.core.Feature;
import ob.core.Value;

public interface ClassifierModelInfo {

	
	Collection<Feature> getFeatures();

	Importance getImportance(Feature feature, int classIndex);
	Effect getEffect(Feature feature, int classIndex, Map<Feature, Value> featureValues);

	String getModelName();

	Value getPrior(int classIndex);
	
	int getNumClasses();

}
