package edu.columbia.preju.prediction.classifier;

import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;

import ob.core.Feature;
import ob.core.NumericFeature;

/**
 * @author Or
 *
 */
public class ClassInfo {

	public static Feature PRIOR_FEATURE = new NumericFeature("prior");
	
	private static final Comparator<Feature> FEATURE_COMPARATOR = new Comparator<Feature>() {
		@Override
		public int compare(Feature arg0, Feature arg1) {
			return arg0.getName().compareTo(arg1.getName());
		}
	};

	private double _prior;
	
	private Map<Feature, Double> _weights = new TreeMap<Feature, Double>(FEATURE_COMPARATOR);
	private Map<Feature, Double> _means = new TreeMap<Feature, Double>(FEATURE_COMPARATOR);

//	private Collection<Feature> _positiveFeatures = new TreeSet<Feature>(FEATURE_COMPARATOR);
//	private Collection<Feature> _negativeFeatures = new TreeSet<Feature>(FEATURE_COMPARATOR);
//	private Collection<Feature> _meaninglessFeatures = new TreeSet<Feature>(FEATURE_COMPARATOR);

	public void setWeight(Feature feature, double weight) {
		_weights.put(feature, weight);

//		if (weight > 0) _positiveFeatures.add(feature);
//		else if (weight < 0) _negativeFeatures.add(feature);
//		else if (weight == 0) _meaninglessFeatures.add(feature);
	}

	public void setMean(Feature feature, double mean) {
		_means.put(feature, mean);
	}

	public void setPrior(double prior) {
		_prior = prior;
		
		Feature priorFeature = PRIOR_FEATURE;
		
//		if (prior > 0) _positiveFeatures.add(priorFeature);
//		else if (prior < 0) _negativeFeatures.add(priorFeature);
//		else _meaninglessFeatures.add(priorFeature);
		
		_weights.put(priorFeature, 1.0);
		_means.put(priorFeature, prior);
	}

	public Collection<Feature> getFeatures() {
		return _weights.keySet();
	}

	public double getWeight(Feature feature) {
		return _weights.get(feature);
	}

	public double getMean(Feature feature) {
		return _means.get(feature);
	}

	public double getPrior() {
		return _prior;
	}

}
