package edu.columbia.preju.prediction.classifier;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import ob.core.CentralFactory;
import ob.core.Feature;
import ob.core.Value;
import edu.columbia.preju.core.Effect;
import edu.columbia.preju.core.Importance;
import edu.columbia.preju.core.SimpleEffect;
import edu.columbia.preju.core.SimpleImportance;

public abstract class AbstractLinearClassifierModelInfo implements ClassifierModelInfo {

	private Map<Integer, ClassInfo> _classInfos = new HashMap<Integer, ClassInfo>();
	
	@Override
	public Collection<Feature> getFeatures() {
		return _classInfos.values().iterator().next().getFeatures();
	}

	@Override
	public Importance getImportance(Feature feature, int classIndex) {
		double weight = _classInfos.get(classIndex).getWeight(feature);
		double mean = _classInfos.get(classIndex).getMean(feature);
		return new SimpleImportance(weight * mean);
	}

	@Override
	public Effect getEffect(Feature feature, int classIndex, Map<Feature, Value> featureValues) {
		double value = featureValues.get(feature).getNumber();
		if (Double.isNaN(value)) value = _classInfos.get(classIndex).getMean(feature);
		double weight = _classInfos.get(classIndex).getWeight(feature);
//		System.out.println(feature.getName() + ": " + value + "  -  " + weight);
		return new SimpleEffect(value * weight);
	}

	@Override
	public Value getPrior(int classIndex) {
		return CentralFactory.getNumericValue(_classInfos.get(classIndex).getPrior());
	}

	protected void addClassInfo(int classIndex, ClassInfo classInfo) {
		_classInfos.put(classIndex, classInfo);
	}

	@Override
	public int getNumClasses() {
		return _classInfos.size();
	}

	
}
