package edu.columbia.preju.keyFeatureSelection;

import java.util.Collection;
import java.util.TreeSet;

import org.jdom2.Element;

import edu.columbia.preju.core.NarrativeRole;
import edu.columbia.preju.prediction.Prediction;
import edu.columbia.preju.roleAssignment.RoleAssignment;
import edu.columbia.preju.xml.XmlObjectFactory;
import ob.core.Feature;

/**
 * @author Or
 *
 */
public class NonNegligibleKeyFeatureSelection implements KeyFeatureSelection, XmlObjectFactory<KeyFeatureSelection> {

	@Override
	public Collection<Feature> getKeyFeatures(Prediction prediction, RoleAssignment roleAssignment) {
		Collection<Feature> keyFeatures = new TreeSet<Feature>(new KeyFeatureComparator(roleAssignment, prediction));
		for (Feature feature : prediction.getFeatures()) {
			if (! roleAssignment.getNarrativeRole(feature, prediction).equals(NarrativeRole.Negligible)) {
				keyFeatures.add(feature);
			}
		}
		return keyFeatures;
	}

	@Override
	public KeyFeatureSelection createFromXml(Element element, Prediction prediction) {
		return new NonNegligibleKeyFeatureSelection();
	}

}
