package edu.columbia.preju.keyFeatureSelection;

import java.util.Comparator;

import edu.columbia.preju.prediction.Prediction;
import edu.columbia.preju.roleAssignment.RoleAssignment;

import ob.core.Feature;

/**
 * @author Or
 *
 */
public class KeyFeatureComparator implements Comparator<Feature> {

	private RoleAssignment _roleAssignment;
	private Prediction _prediction;

	public KeyFeatureComparator(RoleAssignment roleAssignment, Prediction prediction) {
		_roleAssignment = roleAssignment;
		_prediction = prediction;
	}

	@Override
	public int compare(Feature o1, Feature o2) {
		int comparison = _roleAssignment.getNarrativeRole(o1, _prediction).compareTo(_roleAssignment.getNarrativeRole(o2, _prediction));
		if (comparison == 0) {
			comparison = o1.getName().compareTo(o2.getName());
		}
		return comparison;
	}

}
