package edu.columbia.preju.keyFeatureSelection;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;

import org.jdom2.Element;

import edu.columbia.preju.core.NarrativeRole;
import edu.columbia.preju.prediction.Prediction;
import edu.columbia.preju.roleAssignment.RoleAssignment;
import edu.columbia.preju.util.PrejuUtils;
import edu.columbia.preju.xml.XmlObjectFactory;
import ob.core.Feature;

/**
 * @author Or
 *
 */
public class HighestEffectKeyFeatureSelection implements KeyFeatureSelection, XmlObjectFactory<KeyFeatureSelection> {

	private int _n;
	private Collection<NarrativeRole> _acceptedRoles;

	public HighestEffectKeyFeatureSelection() {
	}

	public HighestEffectKeyFeatureSelection(int n) {
		this(n, null);
	}

	public HighestEffectKeyFeatureSelection(int n, Collection<NarrativeRole> acceptedRoles) {
		_n = n;
		_acceptedRoles = acceptedRoles;
	}


	@Override
	public Collection<Feature> getKeyFeatures(Prediction prediction, RoleAssignment roleAssignment) {
		List<Feature> sortedFeatures = PrejuUtils.getEffectSortedFeatures(prediction);
		
		Collection<Feature> keyFeatures = new TreeSet<Feature>(new KeyFeatureComparator(roleAssignment, prediction));
		
		int c = 0;
		for (int i=0; i<sortedFeatures.size(); i++) {
			Feature feature = sortedFeatures.get(i);
			if (isAcceptedRole(roleAssignment.getNarrativeRole(feature, prediction))) {
				keyFeatures.add(feature);
				c++;
				if (c==_n) break;
			}
		}
		
		return keyFeatures;
	}

	private boolean isAcceptedRole(NarrativeRole narrativeRole) {
		if (_acceptedRoles == null) return true;
		else return _acceptedRoles.contains(narrativeRole);
	}

	public int getN() {
		return _n;
	}

	public void setN(int n) {
		_n = n;
	}

	public Collection<NarrativeRole> getAcceptedRoles() {
		return _acceptedRoles;
	}

	public void setAcceptedRoles(Collection<NarrativeRole> acceptedRoles) {
		_acceptedRoles = acceptedRoles;
	}

	@Override
	public KeyFeatureSelection createFromXml(Element element, Prediction prediction) {
		int n = Integer.parseInt(element.getChildTextNormalize("n"));
		Collection<NarrativeRole> acceptedRoles = new HashSet<NarrativeRole>();
		for (Element roleElement : element.getChildren("acceptedRole")) {
			acceptedRoles.add(NarrativeRole.valueOf(roleElement.getTextNormalize()));
		}
		if (acceptedRoles.isEmpty()) acceptedRoles = null;
		return new HighestEffectKeyFeatureSelection(n, acceptedRoles);
	}
	
}
