package edu.columbia.preju.keyFeatureSelection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

import org.jdom2.Element;

import ob.core.Feature;
import edu.columbia.preju.core.NarrativeRole;
import edu.columbia.preju.prediction.Prediction;
import edu.columbia.preju.roleAssignment.RoleAssignment;
import edu.columbia.preju.util.PrejuUtils;
import edu.columbia.preju.xml.XmlObjectFactory;

public class GroupTopKeyFeatureSelection implements KeyFeatureSelection, XmlObjectFactory<KeyFeatureSelection> {

	private int _n;

	
	public GroupTopKeyFeatureSelection() {
	}

	public GroupTopKeyFeatureSelection(int n) {
		_n = n;
	}

	@Override
	public Collection<Feature> getKeyFeatures(Prediction prediction, RoleAssignment roleAssignment) {
		Collection<Feature> keyFeatures = new TreeSet<Feature>(new KeyFeatureComparator(roleAssignment, prediction));

		List<Feature> effectSortedFeatures = PrejuUtils.getEffectSortedFeatures(prediction);
		List<Feature> importanceSortedFeatures = PrejuUtils.getImportanceSortedFeatures(prediction);

		// add evidence features
		keyFeatures.addAll(getTopFeatures(effectSortedFeatures, NarrativeRole.EVIDENCE_ROLES, prediction, roleAssignment));

		// add missing evidence features
		keyFeatures.addAll(getTopFeatures(importanceSortedFeatures, NarrativeRole.MISSING_EVIDENCE_ROLES, prediction, roleAssignment));

		// add counter evidence features
		keyFeatures.addAll(getTopFeatures(effectSortedFeatures, NarrativeRole.COUNTER_EVIDENCE_ROLES, prediction, roleAssignment));

		// add missing counter evidence features
		keyFeatures.addAll(getTopFeatures(importanceSortedFeatures, NarrativeRole.MISSING_COUNTER_EVIDENCE_ROLES, prediction, roleAssignment));

		return keyFeatures;
	}

	private Collection<? extends Feature> getTopFeatures(List<Feature> sortedFeatures, Set<NarrativeRole> roles, Prediction prediction, RoleAssignment roleAssignment) {
		Collection<Feature> topFeatures = new ArrayList<Feature>();
		
		int c = 0;
		for (int i=0; i<sortedFeatures.size(); i++) {
			Feature feature = sortedFeatures.get(i);
			if (roles.contains(roleAssignment.getNarrativeRole(feature, prediction))) {
				topFeatures.add(feature);
				c++;
				if (c==_n) break;
			}
		}
		
		return topFeatures;
	}

	public int getN() {
		return _n;
	}

	public void setN(int n) {
		_n = n;
	}

	@Override
	public KeyFeatureSelection createFromXml(Element element, Prediction prediction) {
		int n = Integer.parseInt(element.getChildTextNormalize("n"));
		return new GroupTopKeyFeatureSelection(n);
	}

}
