package edu.columbia.preju.generator.htc;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.io.File;
import java.io.IOException;
import java.util.Map;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

/**
 * @author Or
 *
 */
public class JFreeChartChartGenerator implements ChartGenerator {

	@Override
	public void generateBarChart(Map<String, Double> categoryValueMap, String categoryLabel, String valueLabel, String chartFile) {
		CategoryDataset dataset = createBarDataset(categoryValueMap);
		
		JFreeChart chart = createBarChart(categoryLabel, valueLabel, dataset);

		try {
//			ChartUtilities.saveChartAsJPEG(new File(chartFile), chart, 400, 310);
			ChartUtilities.saveChartAsJPEG(new File(chartFile), chart, 800, 620);
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
	}

	private static CategoryDataset createBarDataset(Map<String, Double> featureEffectMap) {
		DefaultCategoryDataset dataset = new DefaultCategoryDataset();

		for (String name : featureEffectMap.keySet()) {
			dataset.addValue(featureEffectMap.get(name), "bar1", name);
		}

		return dataset;
	}

	private static JFreeChart createBarChart(String categoryLabel, String valueLabel, CategoryDataset dataset) {

		JFreeChart chart = ChartFactory.createBarChart(
				null,						// title
				categoryLabel,				// x-axis (category) label
				valueLabel,					// y-axis (value) label
				dataset,					// data
				PlotOrientation.VERTICAL,	// orientation
				true,						// create legend?
				false,						// generate tooltips?
				false						// generate URLs?
				);

		chart.setBackgroundPaint(Color.white);

		chart.removeLegend();

		ValueMarker marker = new ValueMarker(0);  // position is the value on the axis
		marker.setPaint(Color.black);

		CategoryPlot plot = chart.getCategoryPlot();
		plot.addRangeMarker(marker);

		plot.setBackgroundPaint(getRgbColor("#DDDDDD"));
		
		plot.setRenderer(new PositiveNegativeBarRenderer());

		// disable bar outlines
		final BarRenderer renderer = (BarRenderer) plot.getRenderer();
		renderer.setDrawBarOutline(false);

		final CategoryAxis domainAxis = plot.getDomainAxis();
		domainAxis.setCategoryLabelPositions(
				CategoryLabelPositions.createUpRotationLabelPositions(Math.PI / 6.0)
				);

		return chart;
	}

	public static Color getRgbColor(String colorStr) {
		return new Color(
				Integer.valueOf(colorStr.substring(1, 3), 16),
				Integer.valueOf(colorStr.substring(3, 5), 16),
				Integer.valueOf(colorStr.substring(5, 7), 16) 
				);
	}

	public static class PositiveNegativeBarRenderer extends BarRenderer {

		private static final long serialVersionUID = 8052239143809547414L;


		public PositiveNegativeBarRenderer() {
			super();
		}

		final GradientPaint _positivePaint = new GradientPaint(
				0.0f, 0.0f, Color.blue, 
				0.0f, 0.0f, Color.cyan
				);

		final GradientPaint _negativePaint = new GradientPaint(
				0.0f, 0.0f, Color.red, 
				0.0f, 0.0f, Color.magenta
				);

		final GradientPaint _totalPaint = new GradientPaint(
				0.0f, 0.0f, Color.black, 
				0.0f, 0.0f, Color.gray
				);


		public Paint getItemPaint(int x_row, int x_col) {
			CategoryDataset l_jfcDataset = getPlot().getDataset();
			String l_rowKey = (String)l_jfcDataset.getRowKey(x_row);
			String l_colKey = (String)l_jfcDataset.getColumnKey(x_col);
			double l_value  = l_jfcDataset.getValue(l_rowKey, l_colKey).doubleValue();
			if (x_row == 0 && x_col == 0) return _totalPaint;
			if (l_value < 0.0) { return _negativePaint; }
			else { return _positivePaint; }
		}
	}

	

}
