package edu.columbia.preju.generator.htc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

import edu.columbia.ob.gen.core.SemanticUnit;
import edu.columbia.ob.gen.realizer.LexicalChoice;
import ob.util.Utils;

/**
 * @author Or
 *
 */
public class HandCraftedLexicalChoice implements LexicalChoice {

	private static final int WINDOW_SIZE = 5;
	
	private Map<String, List<String>> _map = buildMap();


	@Override
	public String doLexicalChoice(String sentence, SemanticUnit su) {
		StringBuffer sb = new StringBuffer();
		
		String[] words = sentence.split("\\s+");
		for (int i=0; i<words.length; i++) {
			String word = words[i];
			List<String> context = new ArrayList<String>();
			for (int j=Math.max(0, i-WINDOW_SIZE); j<i; j++) context.add(words[j]);
			for (int j=i+1; j<Math.min(words.length, i+1+WINDOW_SIZE); j++) context.add(words[j]);
			word = chooseLexeme(word, context);
			
			sb.append(word + " ");
		}
		
		return sb.toString().trim();
	}
	
	@Override
	public String chooseLexeme(String word, List<String> context) {
		if (! word.startsWith("#")) return word;
		
		List<String> options = _map.get(word);
		if (options == null) {
			throw new RuntimeException("no lexical choice for " + word);
		}
		return options.get(new Random().nextInt(options.size()));
	}

	private Map<String, List<String>> buildMap() {
		Map<String, List<String>> map = new HashMap<String, List<String>>();

		for (String[] wordAndOptions : WORDS_AND_OPTIONS) {
			map.put(wordAndOptions[0], Utils.list(Arrays.copyOfRange(wordAndOptions, 1, wordAndOptions.length)));
		}
		
		return map;
	}

	private static final String[][] WORDS_AND_OPTIONS = new String[][] {
		new String[] {"#normally", "normally", "usually", "generally", "typically", "in general", "in most cases", "often"},
		new String[] {"#there_is", "there is", "we see"},
		new String[] {"#there_would_be", "there is", "we see", "there would be", "we would see", "we expect to see", "we expect"},
		new String[] {"#strong", "strong", "powerful", "significant", "substantial"},
		new String[] {"#it_is_missing", "it is missing"},
		new String[] {"#in_this_case", "in this case", "in this instance", "in this prediction", "in the current prediction"},
		new String[] {"#main", "main", "central", "most important", "most significant"},
		new String[] {"#prediction", "prediction", "predicted class"},
		new String[] {"#decided", "decided", "arrived at"},
		new String[] {"#exists", "exists", "is", "is seen", "is exhibited"},
		new String[] {"#mostly", "mostly", "mainly"},
		new String[] {"#because_of", "because of", "due to", "based on"},
		new String[] {"#unusual", "unusual", "exceptional", "atypical", "unexpected"},
		new String[] {"#because", "because", "since", "as"},
		new String[] {"#the_rest", "the rest", "the others", "all others"},
		new String[] {"#expected", "expected", "normal", "typical"},
		new String[] {"#constitutes", "constitutes", "forms", "embodies"},
		new String[] {"#constitute", "constitute", "form", "embody"},
		new String[] {"#reason", "reason", "justification", "explanation", "argument", "grounds", "reasoning", "rationale"},
	};

}
