package edu.columbia.preju.generator;

import java.util.ArrayList;
import java.util.Collection;

import edu.columbia.ob.gen.core.Paragraph;
import edu.columbia.ob.gen.core.SemanticUnit;
import edu.columbia.ob.gen.domainMessageBuilder.DomainMessageBuilder;
import edu.columbia.ob.gen.domainMessageBuilder.PotentialSelectionDomainMessageBuilder;
import edu.columbia.ob.gen.env.DomainInfoMgr;
import edu.columbia.ob.gen.env.PreGenEnv;
import edu.columbia.ob.gen.generator.Generator;
import edu.columbia.ob.gen.planner.DiscourseAndCoherenceDocumentPlanner;
import edu.columbia.ob.gen.planner.DocumentPlanner;
import edu.columbia.ob.gen.realizer.Realizer;
import edu.columbia.ob.gen.realizer.NoOpLexicalChoice;
import edu.columbia.ob.gen.realizer.RandomTemplateRealizer;

/**
 * @author Or
 *
 */
public class PrejuOrbGenGenerator implements Generator {

	private DomainInfoMgr _domainInfoMgr;
	private DomainMessageBuilder _domainMessageBuilder;
	private DocumentPlanner _documentPlanner;
	private Realizer _realizer = new RandomTemplateRealizer(new NoOpLexicalChoice());

	public PrejuOrbGenGenerator(String functionalDomain, String subjectDomain) {
		_domainInfoMgr = PreGenEnv.getDomainInfoMgr(functionalDomain, subjectDomain);
		_domainMessageBuilder = new PotentialSelectionDomainMessageBuilder(_domainInfoMgr);
		_documentPlanner = new DiscourseAndCoherenceDocumentPlanner(_domainInfoMgr);
//		_realizer = PreGenEnv.getRealizer(subjectDomain);
	}
	
	@SuppressWarnings("unchecked")
	public Collection<String> generateParagraphs(Collection<SemanticUnit> coreMessages) {
		Collection<SemanticUnit> domainMessages = _domainMessageBuilder.getDomainMessages(coreMessages);
		Collection<SemanticUnit> allMessages = combine(coreMessages, domainMessages);
		Collection<Paragraph> paragraphs = _documentPlanner.getParagraphs(allMessages);
		Collection<String> textParagraphs = _realizer.realize(paragraphs);
		
		for (String textParagraph : textParagraphs) {
			System.out.println(textParagraph);
			System.out.println();
		}
		
		return textParagraphs;
	}

	@SafeVarargs
	private static <T> Collection<T> combine(Collection<T>...collections) {
		Collection<T> combined = new ArrayList<T>();
		for (Collection<T> collection : collections) combined.addAll(collection);
		return combined;
	}

}
