package edu.columbia.preju.generator;

import java.util.Collection;

import edu.columbia.preju.core.Effect;
import edu.columbia.preju.core.NarrativeRole;
import edu.columbia.preju.keyFeatureSelection.KeyFeatureSelection;
import edu.columbia.preju.prediction.Prediction;
import edu.columbia.preju.roleAssignment.RoleAssignment;
import ob.core.Feature;

/**
 * @author Or
 *
 */
public class JustificationNarrativeImpl implements JustificationNarrative {

	private Prediction _prediction;
	private KeyFeatureSelection _keyFeatureSelection;
	private RoleAssignment _roleAssignment;
	
	private Collection<Feature> _keyFeatures;

	public JustificationNarrativeImpl(Prediction prediction, KeyFeatureSelection keyFeatureSelection, RoleAssignment roleAssignment) {
		_prediction = prediction;
		_keyFeatureSelection = keyFeatureSelection;
		_roleAssignment = roleAssignment;
	}

	@Override
	public Collection<Feature> getFeatures() {
		return _prediction.getFeatures();
	}

	@Override
	public boolean isKeyFeature(Feature feature) {
		return getKeyFeatures().contains(feature);
	}

	@Override
	public Effect getEffect(Feature feature) {
		return _prediction.getEffect(feature);
	}

	@Override
	public NarrativeRole getNarrativeRole(Feature feature) {
		return _roleAssignment.getNarrativeRole(feature, _prediction);
	}

	@Override
	public Collection<Feature> getKeyFeatures() {
		if (_keyFeatures == null) {
			_keyFeatures = _keyFeatureSelection.getKeyFeatures(_prediction, _roleAssignment);
		}
		return _keyFeatures;
	}

	public Prediction getPrediction() {
		return _prediction;
	}

	public KeyFeatureSelection getSelectionStrategy() {
		return _keyFeatureSelection;
	}

	public RoleAssignment getRoleAssignment() {
		return _roleAssignment;
	}

	
}
