package edu.columbia.preju.generator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import edu.columbia.ob.gen.core.SemanticTypedTemplate;
import edu.columbia.ob.gen.core.SemanticUnit;
import edu.columbia.ob.gen.core.SemanticUnitImpl;
import edu.columbia.ob.gen.core.TemplateParameter;
import edu.columbia.ob.gen.env.DomainInfoMgr;
import edu.columbia.ob.gen.env.PreGenEnv;
import edu.columbia.preju.core.NarrativeRole;
import ob.core.Feature;
import ob.util.Utils;
import ob.util.collections.MultiMap;

/**
 * @author Or
 *
 */
public class CoreSttParagraphGenerator implements ParagraphGenerator {

//	private DomainInfoMgr _domainInfoMgr;
//
	private Map<String, String> _featureNameToIdMap;
	
//	public CoreSttParagraphGenerator() {
//		_domainInfoMgr = PreGenEnv.getDomainInfoMgr("justification", _subjectDomain);
//	}

	@Override
	public Collection<String> getParagraphs(JustificationNarrative narrative) {
		String subjectDomain = narrative.getPrediction().getSubjectDomainName();
		DomainInfoMgr domainInfoMgr = PreGenEnv.getDomainInfoMgr("justification", subjectDomain);
		
		if (_featureNameToIdMap == null) {
			_featureNameToIdMap = new HashMap<String, String>();
			
			for (TemplateParameter parameter : domainInfoMgr.getTemplateParametersOfType("feature")) {
				_featureNameToIdMap.put(parameter.getName(), parameter.getId());
			}
		}

		Collection<SemanticUnit> coreSus = new ArrayList<SemanticUnit>();

		MultiMap<NarrativeRole, Feature> roleToFeatureMap = makeRoleToFeatureMap(narrative);
		for (NarrativeRole role : roleToFeatureMap.keySet()) {
			String sttId = getSttId(role);
			SemanticTypedTemplate stt = domainInfoMgr.getSemanticTypedTemplate(sttId);
			
			TemplateParameter parameter;
			if (roleToFeatureMap.get(role).size() == 1) {
				String entityId = getIdForFeature(roleToFeatureMap.get(role).iterator().next());
				parameter = domainInfoMgr.getTemplateParameter(entityId);
			}
			else {
				Collection<String> entityIds = getIdsForFeatures(roleToFeatureMap.get(role));
				parameter = domainInfoMgr.getListTemplateParameter(entityIds);
			}
			
			SemanticUnit su = new SemanticUnitImpl(stt, Utils.list(parameter));
			coreSus.add(su);
		}

//		for (Feature feature : narrative.getKeyFeatures()) {
//			String sttId = getSttId(narrative.getNarrativeRole(feature));
//			SemanticTypedTemplate stt = _domainInfoMgr.getSemanticTypedTemplate(sttId);
//			
//			String entityId = getIdForFeature(feature);
//			TemplateParameter parameter = _domainInfoMgr.getTemplateParameter(entityId);
//			
//			SemanticUnit su = new SemanticUnitImpl(stt, Utils.list(parameter));
//			coreSus.add(su);
//		}
		
		return new PrejuOrbGenGenerator("justification", subjectDomain).generateParagraphs(coreSus);
	}

	private MultiMap<NarrativeRole, Feature> makeRoleToFeatureMap(JustificationNarrative narrative) {
		MultiMap<NarrativeRole, Feature> map = new MultiMap<NarrativeRole, Feature>();
		for (Feature feature : narrative.getKeyFeatures()) {
			map.add(narrative.getNarrativeRole(feature), feature);
		}
		return map;
	}

	private Collection<String> getIdsForFeatures(Collection<Feature> features) {
		Collection<String> ids = new ArrayList<String>();
		for (Feature feature : features) ids.add(getIdForFeature(feature));
		return ids;
	}
	
	private String getIdForFeature(Feature feature) {
		return _featureNameToIdMap.get(feature.getName());
	}

	private String getSttId(NarrativeRole narrativeRole) {
		switch (narrativeRole) {
		case ContrarianCounterEvidence:
			return "cs10";
		case ContrarianEvidence:
			return "cs9";
		case ExceptionalCounterEvidence:
			return "cs8";
		case ExceptionalEvidence:
			return "cs7";
		case ExpectedCounterEvidence:
			return "cs4";
		case ExpectedEvidence:
			return "cs3";
		case MissingCounterEvidence:
			return "cs5";
		case MissingEvidence:
			return "cs6";
		case Negligible:
			throw new RuntimeException("WTF?!?");
		default:
			throw new RuntimeException("WTF?!?");
		}
	}

}
