package edu.columbia.preju.core;

import java.util.Set;

import ob.util.Utils;

/**
 * @author Or
 *
 */
public enum NarrativeRole {
	
	ExpectedEvidence, 
	ExceptionalEvidence, 
	ContrarianEvidence, 
	MissingEvidence, 
	MissingCounterEvidence,
	Negligible,
	ExpectedCounterEvidence, 
	ExceptionalCounterEvidence, 
	ContrarianCounterEvidence; 

	public static final Set<NarrativeRole> EVIDENCE_ROLES = Utils.set(ExpectedEvidence, ExceptionalEvidence, ContrarianEvidence);
	public static final Set<NarrativeRole> MISSING_EVIDENCE_ROLES = Utils.set(MissingEvidence);
	public static final Set<NarrativeRole> COUNTER_EVIDENCE_ROLES = Utils.set(ExpectedCounterEvidence, ExceptionalCounterEvidence, ContrarianCounterEvidence);
	public static final Set<NarrativeRole> MISSING_COUNTER_EVIDENCE_ROLES = Utils.set(MissingCounterEvidence);
	
	public boolean isEvidenceRole() {
		return EVIDENCE_ROLES.contains(this);
	}

	public boolean isCounterEvidenceRole() {
		return COUNTER_EVIDENCE_ROLES.contains(this);
	}

}
