package edu.columbia.preju.app;

import edu.columbia.preju.configuration.JustificationConfiguration;
import edu.columbia.preju.generator.JustificationGenerator;
import edu.columbia.preju.generator.JustificationNarrative;
import edu.columbia.preju.generator.JustificationNarrativeImpl;
import edu.columbia.preju.prediction.Prediction;
import edu.columbia.preju.xml.XmlConfigurationFactory;
import edu.columbia.preju.xml.XmlPredictionFactory;

/**
 * @author Or
 *
 */
public class GenerateJustification {

	public static void main(String[] args) {

		if (args.length != 2) {
			System.out.println("Two args expected. Usage:  GenerateJustification <predictionXmlFile> <configurationXmlFile>");
			System.exit(0);
		}
		
		String predictionXmlFile = args[0];
		Prediction prediction = XmlPredictionFactory.getClassifierPrediction(predictionXmlFile);
		prediction.exportSubjectDomainPackage();
		
		String configurationXmlFile = args[1];
		JustificationConfiguration configuration = XmlConfigurationFactory.getConfiguration(configurationXmlFile, prediction);

		JustificationNarrative narrative = new JustificationNarrativeImpl(prediction, configuration.getKeyFeatureSelection(), configuration.getRoleAssignment());
		
		JustificationGenerator generator = configuration.getJustificationGenerator();
		
		generator.generate(narrative);
	}

}
