/*
 * Decompiled with CFR 0.152.
 */
package ob.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Utils {
    public static String ucFirst(String string) {
        return String.valueOf(string.substring(0, 1).toUpperCase()) + string.substring(1);
    }

    public static Matcher getMatcher(String string, String regex) {
        Pattern pattern = Pattern.compile(regex);
        return pattern.matcher(string);
    }

    public static String matchGroup1(String string, String regex) {
        Matcher matcher = Utils.getMatcher(string, regex);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public static String replaceSubstring(String string, int start, int end, String replacement) {
        return String.valueOf(start > 0 ? string.substring(0, start) : "") + replacement + (end <= string.length() ? string.substring(end, string.length()) : "");
    }

    public static int countMatches(String string, String regex) {
        Matcher matcher = Utils.getMatcher(string, regex);
        int count = 0;
        while (matcher.find()) {
            ++count;
        }
        return count;
    }

    public static int countOccurances(String string, String substring) {
        int count = 0;
        int index = string.indexOf(substring);
        while (index >= 0) {
            ++count;
            string = string.substring(index + 1);
            index = string.indexOf(substring);
        }
        return count;
    }

    public static String repeatString(String string, int times) {
        String repeat = "";
        int i = 0;
        while (i < times) {
            repeat = String.valueOf(repeat) + string;
            ++i;
        }
        return repeat;
    }

    public static <T> List<T> reverse(List<T> list) {
        ArrayList<T> reverseList = new ArrayList<T>();
        for (T object : list) {
            reverseList.add(0, object);
        }
        return reverseList;
    }

    public static <T> List<T> copy(List<T> list) {
        ArrayList<T> copy = new ArrayList<T>(list.size());
        copy.addAll(list);
        return copy;
    }

    @SafeVarargs
    public static <T> List<T> list(T ... objs) {
        ArrayList<T> list = new ArrayList<T>();
        T[] TArray = objs;
        int n = objs.length;
        int n2 = 0;
        while (n2 < n) {
            T obj = TArray[n2];
            list.add(obj);
            ++n2;
        }
        return list;
    }

    public static List<Object> objectList(Object ... objs) {
        ArrayList<Object> list = new ArrayList<Object>();
        Object[] objectArray = objs;
        int n = objs.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            list.add(obj);
            ++n2;
        }
        return list;
    }

    @SafeVarargs
    public static <T> Set<T> set(T ... objs) {
        HashSet<T> set = new HashSet<T>();
        T[] TArray = objs;
        int n = objs.length;
        int n2 = 0;
        while (n2 < n) {
            T obj = TArray[n2];
            set.add(obj);
            ++n2;
        }
        return set;
    }

    public static int sumArray(int[] array) {
        int sum = 0;
        int i = 0;
        while (i < array.length) {
            sum += array[i];
            ++i;
        }
        return sum;
    }

    public static int sumCollection(Collection<Integer> collection) {
        int sum = 0;
        for (Integer integer : collection) {
            sum += integer.intValue();
        }
        return sum;
    }

    public static double doublePrecision(double x, int precision) {
        int precInt = (int)Math.pow(10.0, precision);
        long y = (long)(x * (double)precInt);
        return (double)y / (double)precInt;
    }

    private static FileReader getFileReader(String filename) {
        try {
            return new FileReader(filename);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("File not found: " + filename, e);
        }
    }

    public static List<String> readLines(String filename) {
        BufferedReader reader = new BufferedReader(Utils.getFileReader(filename));
        ArrayList<String> lines = new ArrayList<String>();
        try {
            while (reader.ready()) {
                lines.add(reader.readLine());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot read from file " + filename, e);
        }
        return lines;
    }

    public static Iterable<String> readLinesDynamically(String filename) {
        final BufferedReader reader = new BufferedReader(Utils.getFileReader(filename));
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    String _next = null;

                    @Override
                    public boolean hasNext() {
                        if (this._next == null) {
                            try {
                                this._next = reader.readLine();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        return this._next != null;
                    }

                    @Override
                    public String next() {
                        if (this.hasNext()) {
                            String line = this._next;
                            this._next = null;
                            return line;
                        }
                        try {
                            reader.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return null;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static String readText(String filename) {
        String text = "";
        for (String line : Utils.readLines(filename)) {
            text = String.valueOf(text) + line + "\n";
        }
        return text;
    }

    public static boolean fileExists(String filename) {
        File file = new File(filename);
        return file.exists();
    }

    public static <T> T coalesce(T value, T defaultValue) {
        return value == null ? defaultValue : value;
    }

    public static List<String> listFileNames(String dir) {
        File dirFile = new File(dir);
        String[] files = dirFile.list();
        return Arrays.asList(files);
    }

    public static List<File> listFiles(String dir) {
        File dirFile = new File(dir);
        File[] files = dirFile.listFiles();
        return Arrays.asList(files);
    }

    public static void writeToFile(String filename, String text) {
        try {
            PrintWriter writer = new PrintWriter(filename);
            writer.print(text);
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException("cannot open file " + filename + " for writing", e);
        }
    }

    public static void writeLinesToFile(String filename, Collection<String> lines) {
        try {
            PrintWriter writer = new PrintWriter(filename);
            for (String line : lines) {
                writer.print(String.valueOf(line) + "\n");
            }
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException("cannot open file " + filename + " for writing", e);
        }
    }

    public static void appendLinesToFile(String filename, Collection<String> lines) {
        try {
            PrintWriter writer = new PrintWriter(new FileOutputStream(new File(filename), true));
            for (String line : lines) {
                writer.print(String.valueOf(line) + "\n");
            }
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException("cannot open file " + filename + " for writing", e);
        }
    }

    public static boolean containsIgnoreCase(String text, String target) {
        return text.toLowerCase().contains(target.toLowerCase());
    }

    public static boolean containsIgnoreCase(Collection<String> strings, String target) {
        for (String string : strings) {
            if (!string.toLowerCase().equals(target.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public static Date parseDate(String string, DateFormat format) {
        try {
            return format.parse(string);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static String formatDouble(Double d) {
        return NumberFormat.getInstance().format(d);
    }

    public static List<String> linesFromUrl(String url) {
        try {
            URL u = new URL(url);
            BufferedReader reader = new BufferedReader(new InputStreamReader(u.openStream()));
            ArrayList<String> lines = new ArrayList<String>();
            while (reader.ready()) {
                lines.add(reader.readLine());
            }
            reader.close();
            return lines;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String textFromUrl(String url) {
        try {
            URL u = new URL(url);
            BufferedReader reader = new BufferedReader(new InputStreamReader(u.openStream()));
            String text = "";
            while (reader.ready()) {
                text = String.valueOf(text) + reader.readLine();
            }
            reader.close();
            return text;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void copyFile(File src, File dst) {
        try {
            int len;
            FileInputStream in = new FileInputStream(src);
            FileOutputStream out = new FileOutputStream(dst);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String usedMemory() {
        System.gc();
        return String.valueOf((Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L) + "K";
    }

    public static String normalizeString(String str) {
        str = str.toLowerCase();
        str = str.replaceAll("[^a-z0-9_]", "_");
        str = str.trim();
        return str;
    }
}

