/*
 * Decompiled with CFR 0.152.
 */
package ob.util;

import java.text.Normalizer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import ob.util.Utils;

public class CharacterUtils {
    private static Collection<Character> _chars;
    private static Collection<Character> _letters;
    private static Collection<Character> _digits;
    private static Map<Character, Character> _normalizationMap;
    private static Collection<Character> _junkPrefixChars;
    private static Collection<Character> _junkSuffixChars;

    static {
        char[] junkSuffixChars;
        char[] junkPrefixChars;
        char[] digits;
        char[] letters;
        char[] chars;
        _chars = new HashSet<Character>();
        _letters = new HashSet<Character>();
        _digits = new HashSet<Character>();
        _normalizationMap = new HashMap<Character, Character>();
        _junkPrefixChars = new HashSet<Character>();
        _junkSuffixChars = new HashSet<Character>();
        char[] cArray = chars = new char[]{'_', '=', ',', '.', '?', '!', '%', '$', '#', '@', '^', '&', '*', '(', ')', '[', ']', '{', '}', ':', ';', '`', '~', '\'', '\"', '|', '\\', '/', '-', '+', '<', '>'};
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            _chars.add(Character.valueOf(ch));
            ++n2;
        }
        char[] cArray2 = letters = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
        int n3 = letters.length;
        n = 0;
        while (n < n3) {
            char ch = cArray2[n];
            _letters.add(Character.valueOf(ch));
            ++n;
        }
        char[] cArray3 = digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        int n4 = digits.length;
        n3 = 0;
        while (n3 < n4) {
            char ch = cArray3[n3];
            _digits.add(Character.valueOf(ch));
            ++n3;
        }
        for (String line : Utils.readLines("config/unicode_map")) {
            String[] tokens = line.split("\\t");
            Character original = Character.valueOf(tokens[0].charAt(0));
            Character replacement = Character.valueOf(tokens[1].charAt(0));
            _normalizationMap.put(original, replacement);
        }
        char[] cArray4 = junkPrefixChars = new char[]{'_', '=', ',', '.', '?', '!', '%', '$', '#', '@', '^', '&', '*', '(', ')', '[', ']', '{', '}', ':', ';', '`', '~', '\'', '\"', '|', '\\', '/', '-', '+', '<', '>'};
        int n5 = junkPrefixChars.length;
        int tokens = 0;
        while (tokens < n5) {
            char ch = cArray4[tokens];
            _junkPrefixChars.add(Character.valueOf(ch));
            ++tokens;
        }
        char[] cArray5 = junkSuffixChars = new char[]{'_', '=', ',', '.', '?', '!', '%', '$', '#', '@', '^', '&', '*', '(', ')', '[', ']', '{', '}', ':', ';', '`', '~', '\'', '\"', '|', '\\', '/', '-', '+', '<', '>'};
        int n6 = junkSuffixChars.length;
        n5 = 0;
        while (n5 < n6) {
            char ch = cArray5[n5];
            _junkSuffixChars.add(Character.valueOf(ch));
            ++n5;
        }
    }

    public static boolean isNormalCharacter(char ch) {
        return _letters.contains(Character.valueOf(ch)) || _digits.contains(Character.valueOf(ch)) || Character.isWhitespace(ch) || _chars.contains(Character.valueOf(ch));
    }

    public static String removeDiacritics(String input) {
        String nrml = Normalizer.normalize(input, Normalizer.Form.NFD);
        StringBuilder stripped = new StringBuilder();
        int i = 0;
        while (i < nrml.length()) {
            char ch = nrml.charAt(i);
            if (Character.getType(ch) != 6) {
                stripped.append(ch);
            }
            ++i;
        }
        return stripped.toString();
    }

    public static String removeNonLetters(String token) {
        return token.replaceAll("[^A-Za-z]", "");
    }

    public static String removeJunkPrefixesAndSuffixes(String nword) {
        String nword2 = "";
        boolean foundLetter = false;
        char[] cArray = nword.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            if (!_junkPrefixChars.contains(Character.valueOf(ch))) {
                nword2 = String.valueOf(nword2) + ch;
                foundLetter = true;
            } else if (foundLetter) {
                nword2 = String.valueOf(nword2) + ch;
            }
            ++n2;
        }
        String nword3 = "";
        foundLetter = false;
        int i = nword2.length() - 1;
        while (i >= 0) {
            char ch = nword2.charAt(i);
            if (!_junkSuffixChars.contains(Character.valueOf(ch))) {
                nword3 = String.valueOf(ch) + nword3;
                foundLetter = true;
            } else if (foundLetter) {
                nword3 = String.valueOf(ch) + nword3;
            }
            --i;
        }
        if (nword3.length() > 0) {
            nword = nword3;
        }
        return nword;
    }

    public static boolean hasLetters(String word) {
        char[] cArray = word.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (Character.isLetter(c)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean hasNumbers(String word) {
        char[] cArray = word.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (Character.isDigit(c)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

