/*
 * Decompiled with CFR 0.152.
 */
package ob.ml.util;

import java.util.Collection;
import ob.core.Feature;
import ob.core.FeatureType;
import ob.core.StringFeature;
import ob.core.Value;
import ob.ml.classifier.DataPoint;
import weka.classifiers.Classifier;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.SparseInstance;

public class WekaUtils {
    public static void train(Classifier classifier, Instances dataset) {
        try {
            classifier.buildClassifier(dataset);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static double classify(Classifier classifier, Instance instance) {
        try {
            return classifier.classifyInstance(instance);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static double[] getDistribution(Classifier classifier, Instance instance) {
        try {
            return classifier.distributionForInstance(instance);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Instances getNewYNDataset(int size, String[] attNames, int[] attTypes) {
        FastVector classValues = new FastVector();
        classValues.addElement((Object)"yes");
        classValues.addElement((Object)"no");
        FastVector atts = new FastVector();
        atts.addElement((Object)new Attribute("class", classValues));
        int i = 0;
        while (i < attNames.length) {
            if (attTypes[i] == 0) {
                atts.addElement((Object)new Attribute(attNames[i]));
            }
            if (attTypes[i] == 2) {
                atts.addElement((Object)new Attribute(attNames[i], null));
            }
            ++i;
        }
        Instances dataset = new Instances("data", atts, size);
        dataset.setClassIndex(0);
        return dataset;
    }

    public static Instance getNewInstance(Instances dataset, boolean sparse) {
        SparseInstance instance = sparse ? new SparseInstance(dataset.numAttributes()) : new Instance(dataset.numAttributes());
        instance.setDataset(dataset);
        return instance;
    }

    public static Instances makeInstances(Feature classFeature, Collection<Feature> features, int size) {
        FastVector attInfo = new FastVector();
        if (classFeature != null) {
            Attribute classAttribute = WekaUtils.createAttribute(classFeature);
            attInfo.addElement((Object)classAttribute);
        }
        for (Feature feature : features) {
            Attribute attribute = WekaUtils.createAttribute(feature);
            attInfo.addElement((Object)attribute);
        }
        Instances instances = new Instances("dataset", attInfo, size);
        if (classFeature != null) {
            instances.setClassIndex(0);
        }
        return instances;
    }

    private static Attribute createAttribute(Feature feature) {
        if (feature.getType().equals((Object)FeatureType.NUMERIC)) {
            return new Attribute(feature.getName());
        }
        if (feature.getType().equals((Object)FeatureType.STRING)) {
            FastVector nominalValues = new FastVector();
            for (String nominal : ((StringFeature)feature).getNominals()) {
                nominalValues.addElement((Object)nominal);
            }
            return new Attribute(feature.getName(), nominalValues);
        }
        throw new RuntimeException("cannot handle feature type " + (Object)((Object)feature.getType()));
    }

    public static Instance convertToInstance(DataPoint dataPoint, Instances instances) {
        Instance instance = WekaUtils.getNewInstance(instances, dataPoint.isSparse());
        if (dataPoint.getClassFeature() != null) {
            Value classValue = dataPoint.getClassValue();
            Attribute classAttribute = instances.classAttribute();
            if (classAttribute.isNumeric()) {
                instance.setClassValue(classValue.getNumber().doubleValue());
            }
            if (classAttribute.isString() || classAttribute.isNominal()) {
                instance.setClassValue(classValue.getString());
            }
        }
        for (Feature feature : dataPoint.getFeatures()) {
            Value value = dataPoint.getValue(feature);
            Attribute attribute = instances.attribute(feature.getName());
            if (attribute.isNumeric()) {
                Double numberO = value.getNumber();
                double number = numberO;
                instance.setValue(attribute, number);
            }
            if (!attribute.isString() && !attribute.isNominal()) continue;
            instance.setValue(attribute, value.getString());
        }
        instance.setWeight(dataPoint.getWeight());
        return instance;
    }
}

