/*
 * Decompiled with CFR 0.152.
 */
package ob.ml.classifier.weka;

import ob.ml.classifier.Classifier;
import ob.ml.classifier.weka.WekaClassifier;
import weka.classifiers.bayes.NaiveBayes;
import weka.classifiers.functions.LinearRegression;
import weka.classifiers.functions.Logistic;
import weka.classifiers.functions.SMO;
import weka.classifiers.trees.Id3;
import weka.classifiers.trees.J48;

public class WekaClassifierFactory {
    public static WekaClassifier getNaiveBayesClassifier() {
        return new WekaClassifier((weka.classifiers.Classifier)new NaiveBayes());
    }

    public static WekaClassifier getJ48Classifier() {
        J48 j48 = new J48();
        j48.setUnpruned(false);
        j48.setReducedErrorPruning(true);
        return new WekaClassifier((weka.classifiers.Classifier)j48);
    }

    public static WekaClassifier getId3Classifier() {
        return new WekaClassifier((weka.classifiers.Classifier)new Id3());
    }

    public static WekaClassifier getSmoClassifier() {
        return new WekaClassifier((weka.classifiers.Classifier)new SMO());
    }

    public static Classifier load(String file) {
        return new WekaClassifier(file);
    }

    public static Classifier getLogisticClassifier() {
        return new WekaClassifier((weka.classifiers.Classifier)new Logistic());
    }

    public static Classifier getLinearRegression() {
        return new WekaClassifier((weka.classifiers.Classifier)new LinearRegression());
    }
}

