/*
 * Decompiled with CFR 0.152.
 */
package ob.ml.classifier;

import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import ob.core.Feature;
import ob.core.Value;
import ob.ml.classifier.DataPoint;
import ob.ml.classifier.DataPointMetadata;

public class DataPointImpl
implements DataPoint {
    private DataPointMetadata _metadata;
    private Map<Feature, Value> _values = new TreeMap<Feature, Value>();
    private Feature _classFeature;
    private Value _classValue;
    private double _weight = 1.0;
    private Value _defaultSparseValue = null;

    @Override
    public Feature getClassFeature() {
        return this._classFeature;
    }

    @Override
    public Value getClassValue() {
        return this._classValue;
    }

    @Override
    public Collection<Feature> getFeatures() {
        return this._values.keySet();
    }

    @Override
    public Value getValue(Feature feature) {
        Value value = this._values.get(feature);
        if (this.isSparse() && value == null) {
            value = this._defaultSparseValue;
        }
        return value;
    }

    @Override
    public int size() {
        return this._values.size();
    }

    public void addValue(Feature feature, Value value) {
        if (!this.isSparse() || !this._defaultSparseValue.equals(value)) {
            this._values.put(feature, value);
        }
    }

    public void setClassFeature(Feature classFeature) {
        this._classFeature = classFeature;
    }

    public void setClassValue(Value classValue) {
        this._classValue = classValue;
    }

    @Override
    public DataPointMetadata getMetadata() {
        return this._metadata;
    }

    public void setMetadata(DataPointMetadata metadata) {
        this._metadata = metadata;
    }

    public void setWeight(double weight) {
        this._weight = weight;
    }

    @Override
    public double getWeight() {
        return this._weight;
    }

    @Override
    public Value getDefaultSparseValue() {
        return this._defaultSparseValue;
    }

    public void setDefaultSparseValue(Value defaultSparseValue) {
        this._defaultSparseValue = defaultSparseValue;
    }

    @Override
    public boolean isSparse() {
        return this._defaultSparseValue != null;
    }
}

