/*
 * Decompiled with CFR 0.152.
 */
package ob.ml;

import java.text.NumberFormat;
import java.util.Map;
import java.util.TreeMap;

public class MultiClassEvaluation {
    private Map<String, Integer> _predictedCounts = new TreeMap<String, Integer>();
    private Map<String, Integer> _actualCounts = new TreeMap<String, Integer>();
    private Map<String, Integer> _tp = new TreeMap<String, Integer>();
    private Map<String, Integer> _fp = new TreeMap<String, Integer>();
    private Map<String, Integer> _fn = new TreeMap<String, Integer>();
    private int _hits = 0;
    private int _misses = 0;

    public void addPoint(String predicted, String actual) {
        Integer count = this._predictedCounts.get(predicted);
        if (count == null) {
            count = 0;
        }
        count = count + 1;
        this._predictedCounts.put(predicted, count);
        count = this._actualCounts.get(actual);
        if (count == null) {
            count = 0;
        }
        count = count + 1;
        this._actualCounts.put(actual, count);
        if (predicted.equals(actual)) {
            ++this._hits;
            count = this._tp.get(actual);
            if (count == null) {
                count = 0;
            }
            count = count + 1;
            this._tp.put(actual, count);
        } else {
            ++this._misses;
            count = this._fn.get(actual);
            if (count == null) {
                count = 0;
            }
            count = count + 1;
            this._fn.put(actual, count);
            count = this._fp.get(predicted);
            if (count == null) {
                count = 0;
            }
            count = count + 1;
            this._fp.put(predicted, count);
        }
    }

    public String toResultString() {
        String result = "class:  predicted (actual)\n";
        for (String claz : this._actualCounts.keySet()) {
            result = String.valueOf(result) + claz + ":  " + this._predictedCounts.get(claz) + " (" + this._actualCounts.get(claz) + ")  ---  " + this.df(this.getPrecision(claz)) + ", " + this.df(this.getRecall(claz)) + "\n";
        }
        result = String.valueOf(result) + "Accuracy: " + this.df(this.getAccuracy()) + "\n";
        return result;
    }

    private Double getRecall(String claz) {
        return (double)this.zeroIfNull(this._tp.get(claz)) / (double)(this.zeroIfNull(this._tp.get(claz)) + this.zeroIfNull(this._fn.get(claz)));
    }

    private Double getPrecision(String claz) {
        return (double)this.zeroIfNull(this._tp.get(claz)) / (double)(this.zeroIfNull(this._tp.get(claz)) + this.zeroIfNull(this._fp.get(claz)));
    }

    private int zeroIfNull(Integer i) {
        if (i == null) {
            return 0;
        }
        return i;
    }

    private String df(Double d) {
        return NumberFormat.getPercentInstance().format(d);
    }

    private Double getAccuracy() {
        return (double)this._hits / (double)(this._hits + this._misses);
    }
}

