/*
 * Decompiled with CFR 0.152.
 */
package ob.ml;

import java.text.NumberFormat;

public class BinaryEvaluation {
    private double _tp = 0.0;
    private double _fp = 0.0;
    private double _tn = 0.0;
    private double _fn = 0.0;

    public void addTruePositive() {
        this._tp += 1.0;
    }

    public void addFalsePositive() {
        this._fp += 1.0;
    }

    public void addTrueNegative() {
        this._tn += 1.0;
    }

    public void addFalseNegative() {
        this._fn += 1.0;
    }

    public void addPoint(boolean predictedValue, boolean trueValue) {
        if (predictedValue && trueValue) {
            this.addTruePositive();
        }
        if (predictedValue && !trueValue) {
            this.addFalsePositive();
        }
        if (!predictedValue && trueValue) {
            this.addFalseNegative();
        }
        if (!predictedValue && !trueValue) {
            this.addTrueNegative();
        }
    }

    public int getTruePositives() {
        return (int)this._tp;
    }

    public int getFalsePositives() {
        return (int)this._fp;
    }

    public int getTrueNegatives() {
        return (int)this._tn;
    }

    public int getFalseNegatives() {
        return (int)this._fn;
    }

    public void addTruePositives(int tp) {
        this._tp += (double)tp;
    }

    public void addFalsePositives(int fp) {
        this._fp += (double)fp;
    }

    public void addTrueNegatives(int tn) {
        this._tn += (double)tn;
    }

    public void addFalseNegatives(int fn) {
        this._fn += (double)fn;
    }

    public Double getAccuracy() {
        return (this._tp + this._tn) / (this._tp + this._fp + this._tn + this._fn);
    }

    public Double getPrecision() {
        return this._tp / (this._tp + this._fp);
    }

    public Double getRecall() {
        return this._tp / (this._tp + this._fn);
    }

    public Double getFMeasure() {
        double precision = this.getPrecision();
        double recall = this.getRecall();
        return 2.0 * precision * recall / (precision + recall);
    }

    public Integer getNumObservations() {
        return (int)(this._tp + this._fp + this._tn + this._fn);
    }

    public void addAllPoints(BinaryEvaluation evaluation) {
        this._tp += evaluation._tp;
        this._fp += evaluation._fp;
        this._tn += evaluation._tn;
        this._fn += evaluation._fn;
    }

    public String toResultString() {
        return "\n# points:  " + this.getNumObservations() + "\n" + "accuracy:  " + BinaryEvaluation.formatDouble(this.getAccuracy()) + "\n" + "precision: " + BinaryEvaluation.formatDouble(this.getPrecision()) + "\n" + "recall:    " + BinaryEvaluation.formatDouble(this.getRecall()) + "\n" + "f-measure: " + BinaryEvaluation.formatDouble(this.getFMeasure()) + "\n";
    }

    public String toFullResultString() {
        return "\n# points:        " + this.getNumObservations() + "\n" + "true positives:  " + this._tp + "\n" + "false positives: " + this._fp + "\n" + "false negatives: " + this._fn + "\n" + "true negatives:  " + this._tn + "\n" + "accuracy:  " + BinaryEvaluation.formatDouble(this.getAccuracy()) + "\n" + "precision: " + BinaryEvaluation.formatDouble(this.getPrecision()) + "\n" + "recall:    " + BinaryEvaluation.formatDouble(this.getRecall()) + "\n" + "f-measure: " + BinaryEvaluation.formatDouble(this.getFMeasure()) + "\n";
    }

    private static String formatDouble(Double number) {
        NumberFormat nf = NumberFormat.getPercentInstance();
        nf.setMaximumFractionDigits(4);
        return nf.format(number);
    }
}

