/*
 * Decompiled with CFR 0.152.
 */
package ob.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import ob.core.AbstractFeature;
import ob.core.Feature;
import ob.core.FeatureType;

public class StringFeature
extends AbstractFeature {
    private List<String> _nominals;

    public StringFeature(String name, List<String> nominals) {
        super(name);
        this._nominals = nominals;
    }

    public StringFeature(String name) {
        this(name, new ArrayList<String>());
    }

    @Override
    public FeatureType getType() {
        return FeatureType.STRING;
    }

    @Override
    protected boolean featureEquals(Feature other) {
        if (!(other instanceof StringFeature)) {
            return false;
        }
        StringFeature sf = (StringFeature)other;
        if (this._nominals == null) {
            return sf._nominals == null;
        }
        if (sf._nominals == null) {
            return false;
        }
        if (this._nominals.size() != sf._nominals.size()) {
            return false;
        }
        int i = 0;
        while (i < this._nominals.size()) {
            if (!this._nominals.get(i).equals(sf._nominals.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Collection<String> getNominals() {
        return this._nominals;
    }

    @Override
    public boolean isNominal() {
        return this.getNominals() != null;
    }

    @Override
    public boolean isNumeric() {
        return false;
    }
}

