/*
 * Decompiled with CFR 0.152.
 */
package ob.core;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import ob.core.Feature;
import ob.core.FeatureVector;

public class FeatureVectorImpl
implements FeatureVector {
    private Map<Feature, Double> _map = new HashMap<Feature, Double>();
    private Double _initialScore = 0.0;
    private Double _euclideanNorm;

    @Override
    public int size() {
        return this.getFeatures().size();
    }

    @Override
    public void increment(Feature feature, double increment) {
        Double score = this._map.get(feature);
        if (score == null) {
            score = this.getInitialScore();
        }
        this._map.put(feature, score + increment);
        this.reset();
    }

    @Override
    public void consolidate(FeatureVector otherVector) {
        for (Feature feature : otherVector.getFeatures()) {
            this.increment(feature, otherVector.getValue(feature));
        }
        this.reset();
    }

    private void reset() {
        this._euclideanNorm = null;
    }

    @Override
    public Collection<Feature> getFeatures() {
        return this._map.keySet();
    }

    @Override
    public Double getValue(Feature feature) {
        return this._map.get(feature);
    }

    @Override
    public Double getInitialScore() {
        return this._initialScore;
    }

    @Override
    public void setInitialScore(Double initialScore) {
        this._initialScore = initialScore;
    }

    @Override
    public void set(Feature feature, double value) {
        this._map.put(feature, value);
        this.reset();
    }

    @Override
    public double euclideanNorm() {
        if (this._euclideanNorm == null) {
            double norm = 0.0;
            for (Feature feature : this.getFeatures()) {
                norm += Math.pow(this.getValue(feature), 2.0);
            }
            norm = Math.sqrt(norm);
            this._euclideanNorm = norm;
        }
        return this._euclideanNorm;
    }

    @Override
    public Collection<Feature> getSortedFeatures() {
        TreeSet<Feature> sortedFeatures = new TreeSet<Feature>(new Comparator<Feature>(){

            @Override
            public int compare(Feature arg0, Feature arg1) {
                int valueComp = FeatureVectorImpl.this.getValue(arg0).compareTo(FeatureVectorImpl.this.getValue(arg1));
                if (valueComp != 0) {
                    return valueComp;
                }
                return arg0.getName().compareTo(arg1.getName());
            }
        });
        sortedFeatures.addAll(this.getFeatures());
        return sortedFeatures;
    }

    @Override
    public void removeFeaturesBelow(double minScore) {
        for (Feature feature : this._map.keySet()) {
            if (!(this._map.get(feature) < minScore)) continue;
            this._map.remove(feature);
        }
        this.reset();
    }
}

