/*
 * Decompiled with CFR 0.152.
 */
package ob.core;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import ob.core.DateTime;
import ob.core.FeatureVector;
import ob.core.FeatureVectorImpl;
import ob.core.NumericValue;
import ob.core.StringValue;
import ob.core.Time;
import ob.core.TimeValue;
import ob.core.Value;
import ob.ml.classifier.DataPoint;
import ob.ml.classifier.DataPointImpl;
import ob.ml.classifier.DataSet;
import ob.ml.classifier.DataSetImpl;
import ob.util.Utils;

public class CentralFactory {
    private static Map<Object, Value> _singletons = new HashMap<Object, Value>();
    private static final DateFormat YYYYMMDD = new SimpleDateFormat("yyyy-MM-dd");
    private static final DateFormat MMMDDYYYY = new SimpleDateFormat("MMM dd, yyyy");

    public static FeatureVector getFeatureVector() {
        return new FeatureVectorImpl();
    }

    public static DataSet getDataSet() {
        return new DataSetImpl();
    }

    public static Value getNumericValue(Double value) {
        return CentralFactory.getSingletonValue(value);
    }

    private static Value getSingletonValue(Double d) {
        Value val = _singletons.get(d);
        if (val == null) {
            val = new NumericValue(d);
            if (d == 1.0 || d == 0.0) {
                _singletons.put(d, val);
            }
        }
        return val;
    }

    public static Value getStringValue(String value) {
        return CentralFactory.getSingletonValue(value);
    }

    private static Value getSingletonValue(String string) {
        Value val = _singletons.get(string);
        if (val == null) {
            val = new StringValue(string);
            _singletons.put(string, val);
        }
        return val;
    }

    public static Value getTimeValue(Time time) {
        return CentralFactory.getSingletonValue(time);
    }

    private static Value getSingletonValue(Time time) {
        Value val = _singletons.get(time);
        if (val == null) {
            val = new TimeValue(time);
            _singletons.put(time, val);
        }
        return val;
    }

    public static DataPoint getDataPoint() {
        return new DataPointImpl();
    }

    public static Time getTime(String string, DateFormat format) {
        return CentralFactory.getTime(Utils.parseDate(string, format));
    }

    public static Time getTimeYYYYMMDD(String dateString) {
        return CentralFactory.getTime(dateString, YYYYMMDD);
    }

    public static Time getTimeMMMDDYYYY(String dateString) {
        return CentralFactory.getTime(dateString, MMMDDYYYY);
    }

    public static Time getTime(Date time) {
        return new DateTime(time);
    }
}

