/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.ob.gen.util;

import com.aliasi.hmm.HiddenMarkovModel;
import com.aliasi.hmm.HmmDecoder;
import com.aliasi.tag.Tagging;
import edu.columbia.ob.gen.env.PreGenEnv;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import ob.util.Utils;

public class PosTagging {
    private static HmmDecoder _decoder;

    public static String[] getPos(String[] words) {
        HmmDecoder decoder = PosTagging.getHmmDecoder();
        Tagging tagging = decoder.tag(Utils.list(words));
        return tagging.tags().toArray(new String[tagging.size()]);
    }

    private static HmmDecoder getHmmDecoder() {
        if (_decoder == null) {
            try {
                FileInputStream fileIn = new FileInputStream(PreGenEnv.getPosTaggerModelFile());
                ObjectInputStream objIn = new ObjectInputStream(fileIn);
                HiddenMarkovModel hmm = (HiddenMarkovModel)objIn.readObject();
                objIn.close();
                fileIn.close();
                _decoder = new HmmDecoder(hmm);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return _decoder;
    }
}

