/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.ob.gen.tester;

import edu.columbia.ob.gen.core.Paragraph;
import edu.columbia.ob.gen.core.SemanticUnit;
import edu.columbia.ob.gen.core.SemanticUnitImpl;
import edu.columbia.ob.gen.domainMessageBuilder.DomainMessageBuilder;
import edu.columbia.ob.gen.domainMessageBuilder.PotentialSelectionDomainMessageBuilder;
import edu.columbia.ob.gen.env.DomainInfoMgr;
import edu.columbia.ob.gen.env.PreGenEnv;
import edu.columbia.ob.gen.planner.DiscourseAndCoherenceDocumentPlanner;
import edu.columbia.ob.gen.planner.DocumentPlanner;
import edu.columbia.ob.gen.realizer.Realizer;
import java.util.ArrayList;
import java.util.Collection;
import ob.util.Utils;

public class GenTester {
    private static DomainInfoMgr _domainInfoMgr = PreGenEnv.getDomainInfoMgr("justification", "afa");
    private static DomainMessageBuilder _domainMessageBuilder = new PotentialSelectionDomainMessageBuilder(_domainInfoMgr);
    private static DocumentPlanner _documentPlanner = new DiscourseAndCoherenceDocumentPlanner(_domainInfoMgr);
    private static Realizer _realizer = PreGenEnv.getRealizer("afa");

    public static void main(String[] args) {
        Collection<SemanticUnit> coreMessages = GenTester.getCoreMessages();
        Collection<SemanticUnit> domainMessages = _domainMessageBuilder.getDomainMessages(coreMessages);
        Collection<SemanticUnit> allMessages = GenTester.combine(coreMessages, domainMessages);
        Collection<Paragraph> paragraphs = _documentPlanner.getParagraphs(allMessages);
        Collection<String> textParagraphs = _realizer.realize(paragraphs);
        for (String textParagraph : textParagraphs) {
            System.out.println(textParagraph);
            System.out.println();
        }
    }

    @SafeVarargs
    private static <T> Collection<T> combine(Collection<T> ... collections) {
        ArrayList<T> combined = new ArrayList<T>();
        Collection<T>[] collectionArray = collections;
        int n = collections.length;
        int n2 = 0;
        while (n2 < n) {
            Collection<T> collection = collectionArray[n2];
            combined.addAll(collection);
            ++n2;
        }
        return combined;
    }

    private static Collection<SemanticUnit> getCoreMessages() {
        ArrayList<SemanticUnit> coreMessages = new ArrayList<SemanticUnit>();
        coreMessages.add(new SemanticUnitImpl(_domainInfoMgr.getSemanticTypedTemplate("cs3"), Utils.list(_domainInfoMgr.getTemplateParameter("de1"))));
        coreMessages.add(new SemanticUnitImpl(_domainInfoMgr.getSemanticTypedTemplate("cs4"), Utils.list(_domainInfoMgr.getTemplateParameter("de2"))));
        coreMessages.add(new SemanticUnitImpl(_domainInfoMgr.getSemanticTypedTemplate("cs5"), Utils.list(_domainInfoMgr.getTemplateParameter("de3"))));
        return coreMessages;
    }
}

