/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.ob.gen.realizer;

import edu.columbia.ob.gen.core.SemanticUnit;
import edu.columbia.ob.gen.core.TemplateParameter;
import edu.columbia.ob.gen.env.PreGenEnv;
import edu.columbia.ob.gen.env.StaticVectors;
import edu.columbia.ob.gen.realizer.LexicalChoice;
import java.io.File;
import java.util.List;
import ob.nlp.util.Porter;
import ob.util.Utils;
import ob.util.collections.MultiMap;

public class TaxonomyLexicalChoice
implements LexicalChoice {
    private static final int CONTEXT_WINDOW = 3;
    private MultiMap<String, String> _synonyms;

    public TaxonomyLexicalChoice(String subjectDomain, boolean doLexicalChoice) {
        if (doLexicalChoice) {
            this._synonyms = this.loadSynonyms(PreGenEnv.getSubjectDomainCorpusDir(subjectDomain));
        }
    }

    @Override
    public String chooseLexeme(String word, List<String> context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String doLexicalChoice(String sentence, SemanticUnit su) {
        if (this._synonyms == null) {
            return sentence;
        }
        for (String term : this._synonyms.keySet()) {
            if (this.isPartOfParameter(term, su)) continue;
            int index = sentence.toLowerCase().indexOf(term);
            while (index != -1) {
                if (this.isWordSeparator(sentence, index - 1) && this.isWordSeparator(sentence, index + term.length())) {
                    double currentSim;
                    String context = this.getContext(sentence, index, index + term.length());
                    double bestScore = currentSim = StaticVectors.getSimilarity(term, context);
                    String bestAlternative = null;
                    for (String alternative : this._synonyms.get(term)) {
                        if (this.isMorphologicalChange(term, alternative)) continue;
                        double alternativeSim = StaticVectors.getSimilarity(alternative, context);
                        if (!((alternativeSim *= (double)term.split("\\s").length / (double)alternative.split("\\s").length) > bestScore)) continue;
                        bestScore = alternativeSim;
                        bestAlternative = alternative;
                    }
                    if (bestAlternative != null) {
                        bestAlternative = this.decorate(bestAlternative, term);
                        System.out.println("LEXICAL CHOICE: '" + bestAlternative + "' (" + bestScore + ") instead of '" + term + "' (" + currentSim + ") in: " + sentence);
                        sentence = String.valueOf(sentence.substring(0, index)) + bestAlternative + sentence.substring(index + term.length());
                    }
                }
                index = sentence.toLowerCase().indexOf(term, index + 1);
            }
        }
        return sentence;
    }

    private boolean isPartOfParameter(String term, SemanticUnit su) {
        for (TemplateParameter param : su.getParameters()) {
            if (!param.getName().toLowerCase().contains(term)) continue;
            return true;
        }
        return false;
    }

    private String decorate(String alternative, String original) {
        if (Character.isUpperCase(original.charAt(0))) {
            String newAlternative = "";
            String[] stringArray = alternative.split("\\s");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String word = stringArray[n2];
                newAlternative = String.valueOf(newAlternative) + " " + Utils.ucFirst(word);
                ++n2;
            }
            return newAlternative.substring(1);
        }
        return alternative;
    }

    private boolean isMorphologicalChange(String term, String alternative) {
        return Porter.stripAffixes(term).equals(Porter.stripAffixes(alternative));
    }

    private boolean isWordSeparator(String sentence, int index) {
        if (index < 0 || index >= sentence.length()) {
            return true;
        }
        char c = sentence.charAt(index);
        if (Character.isWhitespace(c)) {
            return true;
        }
        if (c == ',') {
            return true;
        }
        if (c == '.') {
            return true;
        }
        if (c == '!') {
            return true;
        }
        if (c == '?') {
            return true;
        }
        if (c == ';') {
            return true;
        }
        if (c == ':') {
            return true;
        }
        if (c == '\"') {
            return true;
        }
        if (c == '(') {
            return true;
        }
        return c == ')';
    }

    private String getContext(String sentence, int termStart, int termEnd) {
        String[] before = sentence.substring(0, termStart).toLowerCase().trim().split("\\s+");
        String[] after = sentence.substring(termEnd).toLowerCase().trim().split("\\s+");
        StringBuilder context = new StringBuilder();
        int i = Math.max(0, before.length - 3);
        while (i < before.length) {
            context.append(" " + before[i]);
            ++i;
        }
        i = 0;
        while (i < Math.min(3, after.length)) {
            context.append(" " + after[i]);
            ++i;
        }
        return context.substring(1);
    }

    private MultiMap<String, String> loadSynonyms(String corpusDir) {
        MultiMap<String, String> synonyms = new MultiMap<String, String>();
        for (String line : Utils.readLinesDynamically(new File(corpusDir, "taxonomy").getAbsolutePath())) {
            String[] tokens = line.split("\\t");
            if (!tokens[2].equals("synonym")) continue;
            synonyms.add(tokens[0], tokens[1]);
            synonyms.add(tokens[1], tokens[0]);
        }
        return synonyms;
    }
}

